<?php
/**
 * This file is part of the TelegramBot package.
 *
 * (c) Avtandil Kikabidze aka LONGMAN <akalongman@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Longman\TelegramBot\Commands\SystemCommands;

use Longman\TelegramBot\Commands\SystemCommand;
use Longman\TelegramBot\Conversation;
use Longman\TelegramBot\Entities\InlineKeyboard;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;



/**
 * Start command
 *
 * Gets executed when a user first starts using the bot.
 */
class StartCommand extends SystemCommand
{
    /**
     * @var string
     */
    protected $name = 'start';

    /**
     * @var string
     */
    protected $description = 'Start command';

    /**
     * @var string
     */
    protected $usage = '/start';

    /**
     * @var string
     */
    protected $version = '1.1.0';

    /**
     * @var bool
     */
    protected $private_only = true;
    protected $need_mysql = true;
    protected $conversation;
    public $notes;

    public $message;
    public $message_id;
    public $chat;
    public $user;
    public $text;
    public $chat_id;
    public $user_id;

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {

        $this->message = $this->getMessage();
        $this->message_id = $this->message->getMessageId();
        $this->chat_id = $this->message->getChat()->getId();

        $pdo = DB::getPdo();
        $this->pdo = $pdo;
        $this->pdo->setAttribute($pdo::ATTR_ERRMODE, $pdo::ERRMODE_WARNING);
        $this->pdo->setAttribute($pdo::ATTR_EMULATE_PREPARES, false);
        $this->conversation = new Conversation(
            $this->getMessage()->getFrom()->getId(),
            $this->getMessage()->getChat()->getId()
        );

        $this->notes = &$this->conversation->notes;
        !is_array($this->notes) && $this->notes = [];

        $data['chat_id'] = $this->chat_id;
        $data['text'] = json_encode($this->notes);
        //return Request::sendMessage($data);

        if (!empty($this->notes['lastMsgId'])){
            Request::deleteMessage([
                'chat_id' => $this->chat_id,
                'message_id' => $this->notes['lastMsgId'],
            ]);
        }
        if (!empty($this->notes['msgInicialId'])){
            Request::deleteMessage([
                'chat_id' => $this->chat_id,
                'message_id' => $this->notes['msgInicialId'],
            ]);
        }
        if (!empty($this->notes['msgDadosEnvioId'])){
            Request::deleteMessage([
                'chat_id' => $this->chat_id,
                'message_id' => $this->notes['msgDadosEnvioId'],
            ]);
        }

        $this->conversation->stop();
        $this->conversation = new Conversation(
            $this->getMessage()->getFrom()->getId(),
            $this->getMessage()->getChat()->getId(),
            $this->getName()
        );
        $this->notes = &$this->conversation->notes;
        !is_array($this->notes) && $this->notes = [];

        $pdo = DB::getPdo();
        $sql = "SELECT * FROM usuarios WHERE chat_id = {$this->chat_id}";
        $query = $pdo->query($sql);
        $return = $query->fetch();
        $rows = $query->rowCount();
        if($rows == 0){
            $this->informarCodigoCadastro();
        }
        //$text = "Seja bem vindo! \nClique em \xF0\x9F\x8F\xA0 Menu principal \xF0\x9F\x8F\xA0";
        $text = "\xE2\x9C\xA8 <b>Bem vindo ao Rei dos Aditivos!</b> \xE2\x9C\xA8\n\nAgora você pode comprar seus quitutes diretamente pela nossa loja online.\n\nPara continuar sua compra, clique em\n\xF0\x9F\x8F\xA0 Menu principal \xF0\x9F\x8F\xA0\n\nEm seguida você pode inserir seu saldo e fazer seu pedido.\n\nAgradecemos a sua preferência!";
        $inline_keyboard = new InlineKeyboard(
            [['text' => "\xF0\x9F\x8F\xA0 Menu principal \xF0\x9F\x8F\xA0", 'callback_data' => 'Main_Menu']]

        );
        $data = [
            'chat_id'      => $this->chat_id,
            'text'         => $text,
            'reply_markup' => $inline_keyboard,
            'resize_keyboard' => true,
            'parse_mode' => 'HTML'
        ];

        $result = Request::sendMessage($data);
        $this->conversation->notes['msgInicialId'] = $result->getResult()->getMessageId();
        $this->conversation->notes['msgStart'] = $result->getResult()->getMessageId();

        $this->conversation->update();

    }


    public function informarCodigoCadastro()
    {
    
        $this->chat_id = $this->message->getChat()->getId();
        $this->chat_name = $this->message->getChat()->getFirstName();
        $this->chat_username = $this->message->getChat()->getUsername();
        $usuario_indicador_id = 1;
        if (!empty($this->chat_id) && !empty($this->chat_id)) {

            $dataUsuario = array(
                ':nome' => $this->chat_name,
                ':situacao' => 1,
                ':dataCadastro' => date('Y-m-d'),
                ':permissoes_id' => 6,
                ':chat_id' => $this->chat_id,
                ':representante_id' => 1,
                ':controle_completo' => 0,
                ':dividas' => 0,
                ':user_telegram' => "$this->chat_username",
                ':usuario_indicador_id' => $usuario_indicador_id,

            );
            //$this->sendMessage(json_encode($dataUsuario));
            $sql = "INSERT INTO usuarios (nome, situacao, dataCadastro, permissoes_id, chat_id, usuario_representante_id, controle_completo, dividas, user_telegram, usuario_indicador_id) 
              VALUES (:nome, :situacao, :dataCadastro, :permissoes_id, :chat_id, :representante_id, :controle_completo, :dividas, :user_telegram, :usuario_indicador_id)";

            if ($this->pdo->prepare($sql)->execute($dataUsuario)) {

                $cliente_id = $this->pdo->lastInsertId();
               
                    $sql = "SELECT * FROM usuarios WHERE idUsuarios = {$usuario_indicador_id}";
                    $query = $this->pdo->query($sql);
                    $indicador = $query->fetch();

                    $return_text = "\xF0\x9F\x98\x84 Usuário cadastrado! \xF0\x9F\x98\x84\n\nNome: $this->chat_name";
                    if(!empty($this->chat_username)){
                        $return_text .= "\nUsername: @$this->chat_username";
                    }else{
                        $return_text .= "\nUsuário Sem Username";
                    }
            
                    $inline_keyboard = new InlineKeyboard(
                        [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                    );
                    $this->sendMessageById($indicador['chat_id'], $return_text, $inline_keyboard);
                }
            }

    }

}
