<?php
/**
 * This file is part of the TelegramBot package.
 *
 * (c) Avtandil Kikabidze aka LONGMAN <akalongman@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Longman\TelegramBot\Commands\SystemCommands;


use Longman\TelegramBot\Commands\SystemCommand;
use Longman\TelegramBot\Commands\UserCommand;
use Longman\TelegramBot\Conversation;
use Longman\TelegramBot\Entities\InlineKeyboard;
use Longman\TelegramBot\Entities\InlineKeyboardButton;
use Longman\TelegramBot\Request;
use Longman\TelegramBot\DB;

/**
 * Generic message command
 *
 * Gets executed when any type of message is sent.
 */
class GenericmessageCommand extends UserCommand
{
    /**
     * @var string
     */
    protected $name = 'genericmessage';

    /**
     * @var string
     */
    protected $description = 'Handle generic message';

    /**
     * @var string
     */
    protected $version = '1.1.0';

    /**
     * @var bool
     */
    protected $need_mysql = true;
    protected $conversation;

    public $chat_id;
    public $message;
    public $message_id;
    public $pdo;
    public $user;
    public $notes;


    /**
     * Command execute method if MySQL is required but not available
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function executeNoDb()
    {
        // Do nothing
        return Request::emptyResponse();
    }

    /**
     * Command execute method
     *
     * @return \Longman\TelegramBot\Entities\ServerResponse
     * @throws \Longman\TelegramBot\Exception\TelegramException
     */
    public function execute()
    {

        //If a conversation is busy, execute the conversation command after handling the message
        $this->message = $this->getMessage();
        $this->message_id = $this->message->getMessageId();
        $this->chat_id = $this->message->getChat()->getId();
        $this->chat_name = $this->message->getChat()->getFirstName();
        $this->chat_username = $this->message->getChat()->getUsername();
        $pdo = DB::getPdo();
        $this->pdo = $pdo;
        $this->pdo->setAttribute($pdo::ATTR_ERRMODE, $pdo::ERRMODE_WARNING);
        $this->pdo->setAttribute($pdo::ATTR_EMULATE_PREPARES, false);
        $this->conversation = new Conversation(
            $this->getMessage()->getFrom()->getId(),
            $this->getMessage()->getChat()->getId()
        );

        $this->notes = &$this->conversation->notes;
        !is_array($this->notes) && $this->notes = [];


        if (!empty($this->notes['msgInicialId'])) {
            $this->deleteMessage($this->notes['msgInicialId']);
            $this->notes['msgInicialId'] = null;
        }
        //return $this->deleteMessage(10054);
        //$this->sendMessage(json_encode($this->notes));

        if ($this->notes['lastMsgId'] != $this->notes['msgDadosEnvioId']) {
            $this->deleteMessage($this->notes['lastMsgId']);
        }

        //$this->sendMessage($this->notes['lastMsgId']);
        //return $this->sendMessage($this->notes['msgDadosEnvio']);

        $textMessage = trim($this->message->getText());

        //GUARDANDO DADOS DO USUÁRIO
        $sql = "SELECT * FROM usuarios WHERE chat_id = {$this->chat_id}";
        $query = $pdo->query($sql);
        $this->user = $query->fetch();
        $rows = $query->rowCount();


        if ($rows > 0 or $this->notes['requestData'] == "informarCodigoCadastro") {
            if (!empty($this->notes['requestData'])) {
                $method = $this->notes['requestData'];
                $this->{ucfirst($method)}($textMessage);

            } else {

                $posicao = strpos($textMessage, '---');
                $dados = substr($textMessage, 0, $posicao);
                $produtos = substr($textMessage, $posicao, strlen($textMessage));

                if (!empty($produtos) && !empty($dados)) {

                    $this->InserirPedidoRapido($produtos, $dados);

                } else {
                    $text = "Nenhuma informação de texto foi solicitada. \xF0\x9F\x98\x93";

                    //$this->deleteMessage($this->notes['lastMsgId']);
                    $this->sendMessage($text);
                }

            }
        } else {
            $return_text = "\xF0\x9F\x94\x92 <b>Usuário não cadastrado!</b> \xF0\x9F\x94\x92\nDigite o código de cadastro";
            $this->notes['requestData'] = "informarCodigoCadastro";
            $this->conversation->update();
            $inline_keyboard = new InlineKeyboard();
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x8E\xA7 \xF0\x9F\x91\xA4 Suporte \xF0\x9F\x91\xA4 \xF0\x9F\x8E\xA7",
                'url' => "https://t.me/CrazyGandalf"
            ]));
            $this->sendMessage($return_text, $inline_keyboard);
        }

        if (($this->notes['msgDadosEnvioId'] != $this->message_id) or ($this->notes['msgStart'] != $this->message_id)) {
            $this->deleteMessage($this->message_id);
        }

    }

    public function InformacoesRevenda()
    {

        $textMessage = trim($this->message->getText());
        $text = "<b>Solicitação de revendedor enviada com sucesso!</b>\n\nAguarde o retorno aqui no bot.";
        $usuario_id = $this->user['idUsuarios'];

        $sql = "SELECT * FROM usuarios WHERE idUsuarios = $usuario_id";
        $query = $this->pdo->query($sql);
        $cliente = $query->fetch();

        $textWarnyj = "Pedido de revendor\n";
        $textWarnyj .= "ID: " . $usuario_id . "\n";
        $textWarnyj .= "Nome: " . $cliente['nome'] . "\n";

        $textWarnyj .= "Informações:\n";
        $textWarnyj .= $textMessage;

        //617711684
        //ENVIAR PEDIDO O ADM
        $inline_keyboard_warnyj = new InlineKeyboard(
            [['text' => "\xE2\x9C\x85 Aprovar revededor", 'callback_data' => "Aprovar_Revendedor_$usuario_id"]],
            [['text' => "\xE2\x9D\x8C Reprovar revendedor", 'callback_data' => "Reprovar_Revendedor_$usuario_id"]]
        );

        $this->sendMessageById(889423113, $textWarnyj, $inline_keyboard_warnyj);
        $this->sendMessage($text);
    }


    public function inserirMotivoReclamacaoPedido()
    {
        $venda_id = $this->notes['reclamacaoIdVenda'];

        $textMessage = trim($this->message->getText());
        $text = "<b>Imagem - Pedido #$venda_id:</b>\n";
        $text .= "Coloque um print ou uma imagem que comprove seu problema.";

        $this->notes['reclamacaoMotivo'] = $textMessage;
        $this->notes['requestData'] = "postImagemReclamacaoPedido";
        $this->conversation->update();
        $this->sendMessage($text);


    }

    public function postImagemReclamacaoPedido()
    {
        $message_type = $this->message->getType();
        $venda_id = $this->notes['reclamacaoIdVenda'];
        $reclamacaoMotivo = $this->notes['reclamacaoMotivo'];
        if (in_array(strtolower($this->message->getType()), ['photo'])) {

            $doc = $this->message->{'get' . ucfirst($message_type)}();
            // For photos, get the best quality!
            ($message_type === 'photo') && $doc = end($doc);
            $file = Request::getFile(['file_id' => $doc->getFileId()]);

            if ($file->isOk()) {
                Request::downloadFile($file->getResult());
                $path = $file->getResult()->file_path;
                $complete_path = __DIR__ . "/../../assets/" . $path;

                $file_name = date('Ymis') . '.jpg';
                $new_path = __DIR__ . "/../../assets/reclamacao/photos/" . $file_name;
                $teste = __DIR__ . "/../../assets/reclamacao/photos/";

                if (rename($complete_path, $new_path)) {

                    //SALVOU O ARQUIVO!
                    $this->notes['arquivo'] = $new_path;
                    //$this->notes['link'] = "https://receitasdarkblog.icu/market/assets/comprovantes/photos/$file_name";
                    $this->notes['link'] = "https://receitasdarkblog.icu/market/assets/reclamacao/photos/$file_name";

                    $dataHora = date('Y-m-d H:i:s');
                    $usuario_id = $this->user['idUsuarios'];
                    $dataReclamacao = array(
                        ':usuario_id' => $usuario_id,
                        ':venda_id' => $venda_id,
                        ':datahora' => $dataHora,
                        ':tipo' => "PRODUTO",
                        ':observacao' => $reclamacaoMotivo,
                        ':imagem' => $this->notes['link'],
                        ':status' => 1
                    );

                    $sql = "INSERT INTO reclamacao (usuario_id, venda_id, datahora, tipo, observacao, imagem, status)
              VALUES (:usuario_id, :venda_id, :datahora, :tipo, :observacao, :imagem, :status)";

                    if ($this->pdo->prepare($sql)->execute($dataReclamacao)) {
                        $reclamacaoId = $this->pdo->lastInsertId();
                        $sql = "SELECT * FROM vendas WHERE idVendas = {$venda_id}";
                        $query = $this->pdo->query($sql);
                        $venda = $query->fetch();


                        $sql = "SELECT * FROM usuarios WHERE idUsuarios = $usuario_id";
                        $query = $this->pdo->query($sql);
                        $cliente = $query->fetch();

                        $sql = "SELECT  * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $venda_id";
                        $query = $this->pdo->query($sql);
                        $produtos = $query->fetchAll();
                        $rows = $query->rowCount();
                        $total = 0;

                        $listProd = "";
                        if ($rows > 0) {
                            foreach ($produtos as $produto) {

                                $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";

                            }
                        }
                        if (!empty($venda['tipoEnvio'])) {
                            $listProd .= "\n Envio: " . $venda['tipoEnvio'] . " - R$" . $venda['taxa_envio'];
                        }

                        $inline_keyboard_warnyj = new InlineKeyboard(
                            [['text' => "\xE2\x9C\x85 Solicitar conversa! \xE2\x9C\x85", 'callback_data' => "Conversa_Reclamacao_".$reclamacaoId]],
                            //[['text' => "\xE2\x9C\x85 Reclamação resolvida! \xE2\x9C\x85", 'callback_data' => "Finalizar_Reclamacao"]],
                            //[['text' => "\xE2\x9C\x88 Enviar para o enviador \xE2\x9C\x88", 'callback_data' => "Enviar_Reclamacao_" . $reclamacaoId . "_" . $venda['enviador_id']]],
                            [['text' => "\xF0\x9F\x93\xA5 Excluir aviso \xF0\x9F\x93\xA5", 'callback_data' => "Excluir_Aviso"]]
                        );
                        $text = "<b>Reclamação #$reclamacaoId
                        </b>\n";
                        $text .= "Cliente : " . $cliente['nome'] . "\n";
                        $text .= "Venda : #$venda_id\n";
                        $text .= "Data : " . date('Y-m-d H:i:s') . "\n";
                        $text .= "Dados da venda : " . $venda['dadosEnvio'] . "\n";

                        $text .= "<b>Reclamação : \n<i>$reclamacaoMotivo</i></b>\n\n";
                        $text .= "Produtos\n";
                        $text .= $listProd;
                        //$this->notes['texto_reclamacao'] = $text;
                        //$this->conversation->update();
                        Request::sendPhoto([
                            'caption' => $text,
                            'chat_id' => 889423113,
                            'photo' => $this->notes['link'],
                            'reply_markup' => $inline_keyboard_warnyj,
                            'parse_mode' => 'HTML',
                        ]);

                        $text = "\xE2\x9D\x97 Reclamação feita com sucesso \xE2\x9D\x97 \n";
                        $text .= "Protocolo: #" . $reclamacaoId . "\n";
                        $text .= "Pedido: #" . $venda_id . "\n\n";
                        $text .= "Aguarde o retorno em breve.";


                        $this->sendMessage($text);
                    } else {
                        $this->sendMessage("Teste");
                        $this->sendMessage(json_encode($this->pdo->errorInfo()));
                    }
                } else {

                    $text = "Erro ao renomear o arquivo.";
                    //$text = "Erro ao renomear o arquivo.\n\nComplete Path: $complete_path\n\nFile name: $file_name\n\nNew Path: $new_path";
                    $this->sendErrorMessage($text);
                }
            } else {
                $text = "Não consegui fazer o upload do arquivo.\n\n";
                $this->sendErrorMessage($text);
            }
        } else {
            $text = "Só são aceitos arquivos de imagem.\n\n";
            $this->sendErrorMessage($text);
        }
    }
    public function ConversaReclamacao($reclamacaoId)
    {
        $this->sendMessage('1');
        $sql = "SELECT * FROM reclamacao WHERE id = $reclamacaoId";
        $this->sendMessage($sql);
        $this->sendMessage('Mensagem enviada para '.$cliente['nome']. ', aguarde o contato.');
        $query = $this->pdo->query($sql);
        $reclamacao = $query->fetch();
        $usuario_id = $reclamacao['usuario_id'];
        $sql = "SELECT * FROM usuarios WHERE idUsuarios = $usuario_id";
        $query = $this->pdo->query($sql);
        $this->sendMessage($sql);
        $cliente = $query->fetch();
        $inline_keyboard = new InlineKeyboard(
            [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
        );
        $text = "Sua reclamação foi lida. \nFavor entrar em contato com @ReiDosAditivos";
        $this->sendMessage($text);
        $this->sendMessage('cliente_id '.$cliente['chat_id']);

        //$this->sendMessageById($cliente['chat_id'], $text, $inline_keyboard);


        $this->sendMessage('Mensagem enviada para '.$cliente['nome']. ', aguarde o contato.');
    }


    public function ObseravacaoPedido()
    {
        $venda_id = $this->notes['vendaId'];
        $textMessage = trim($this->message->getText());
        $dataVenda = array(
            ':observacoes' => $textMessage,
            ':venda_id' => $venda_id
        );

        $sql = "UPDATE vendas set observacoes = :observacoes WHERE idVendas = :venda_id";
        $prepSql = $this->pdo->prepare($sql);
        if ($prepSql->execute($dataVenda)) {

            $text = "\xE2\x9C\x85 Obserção atualizada com sucesso!";
            $inline_keyboard = new InlineKeyboard();
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\x8B Confirmar dados \xF0\x9F\x93\x8B",
                'callback_data' => "Confirmar_Dados"
            ]));
            $this->sendMessage($text, $inline_keyboard);
        } else {

        }
    }

    public function informarCodigoCadastro()
    {
        $textMessage = trim($this->message->getText());

        $sql = "SELECT * FROM token_cadastro WHERE token LIKE '{$textMessage}' AND status = 1 AND recebedor_id IS NULL";
        $query = $this->pdo->query($sql);
        $token = $query->fetch();
        if (!empty($token)) {

            $dataUsuario = array(
                ':nome' => $this->chat_name,
                ':situacao' => 1,
                ':dataCadastro' => date('Y-m-d'),
                ':permissoes_id' => 6,
                ':chat_id' => $this->chat_id,
                ':representante_id' => 1,
                ':controle_completo' => 0,
                ':dividas' => 0,
                ':user_telegram' => "$this->chat_username",
                ':usuario_indicador_id' => $token['criador_id'],

            );
            //$this->sendMessage(json_encode($dataUsuario));
            $sql = "INSERT INTO usuarios (nome, situacao, dataCadastro, permissoes_id, chat_id, usuario_representante_id, controle_completo, dividas, user_telegram, usuario_indicador_id) 
              VALUES (:nome, :situacao, :dataCadastro, :permissoes_id, :chat_id, :representante_id, :controle_completo, :dividas, :user_telegram, :usuario_indicador_id)";

            if ($this->pdo->prepare($sql)->execute($dataUsuario)) {

                $cliente_id = $this->pdo->lastInsertId();
                $dataToken = array(
                    //':status' => 0,
                    ':recebedor_id' => $cliente_id,
                    ':status' => 0,
                    ':id' => $token['id']
                );

                $sql = "UPDATE token_cadastro set recebedor_id = :recebedor_id, status = :status WHERE id = :id";
                $prepSql = $this->pdo->prepare($sql);
                if ($prepSql->execute($dataToken)) {
                    $text = "\xE2\x9C\x85 Parabéns você foi cadastrado com sucesso, seja bem vindo e boas compras! 	\xF0\x9F\x98\x83";
                    $this->sendMessage($text);


                    $sql = "SELECT * FROM usuarios WHERE idUsuarios = {$token['criador_id']}";
                    $query = $this->pdo->query($sql);
                    $indicador = $query->fetch();

                    $return_text = "\xF0\x9F\x98\x84 Parabéns um amigo seu utilizou um convite! \xF0\x9F\x98\x84\n\n";
                    $sql = "SELECT * FROM token_cadastro WHERE criador_id = " . $token['criador_id'] . " AND status = 1 AND recebedor_id IS NULL";
                    $query = $this->pdo->query($sql);
                    $tokens = $query->fetchAll();
                    $nTokens = count($tokens);
                    $return_text .= "\xF0\x9F\x94\x96 Você tem $nTokens convite(s) disponíveis\nCompre e ganhe mais convites!";
                    $inline_keyboard = new InlineKeyboard(
                        [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                    );
                    $this->sendMessageById($indicador['chat_id'], $return_text, $inline_keyboard);
                }
            } else {
                //$this->sendMessage($this->pdo->errorInfo());
            }
        } else {
            $return_text = "\xE2\x9B\x94 Código inválido \xE2\x9B\x94";
            $this->sendMessage($return_text);
        }


    }

    public function InserirPedidoRapido($produtos, $dados)
    {

        $dataVenda = date('Y-m-d');

        $dados = trim($dados);
        if (preg_match('/[0-9]{5,5}-[0-9]{3}?/', $dados, $matches)) {

            //if (preg_match('/[0-9]{5,5}([- ]?[0-9]{3,3})?/', $textMessage, $matches)) {
            $cep = $matches[0];
            $vendedor_id = $this->user['idUsuarios'];
            $dataVenda = array(
                ':dataVenda' => $dataVenda,
                ':clientes_id' => 1,
                ':usuarios_id' => $vendedor_id,
                ':faturado' => 0,
                ':desconto' => 0.00,
                ':dadosEnvio' => $dados,
                ':cep' => $cep,
            );

            $sql = "INSERT INTO vendas (dataVenda, clientes_id, usuarios_id, faturado, desconto, dadosEnvio, cep) 
              VALUES (:dataVenda, :clientes_id, :usuarios_id, :faturado, :desconto, :dadosEnvio, :cep)";

            if ($this->pdo->prepare($sql)->execute($dataVenda)) {
                $vendaId = $this->pdo->lastInsertId();
                $enviador = 0;
                $prodArray = array();
                foreach (preg_split("/((\r?\n)|(\r\n?))/", $produtos) as $line) {
                    if ($line != "---") {
                        $cols = explode(' ', $line);
                        $qt = $cols[0];
                        $sigla = $cols[1];
                        $sql = "SELECT * FROM produtos WHERE sigla = '{$sigla}'";
                        $query = $this->pdo->query($sql);
                        $produto = $query->fetch();
                        if (!empty($produto)) {
                            if ($enviador == 0) {
                                $enviador = $produto['usuarioEnvio_id'];
                            }

                            $prodArray[$produto['idProdutos']] = $qt;
                        }
                    }
                }

                $dataVenda = array(
                    ':enviador_id' => $enviador,
                    ':vendaId' => $vendaId,
                );
                $sql = "UPDATE vendas set enviador_id = :enviador_id WHERE idVendas = :vendaId";
                $prepSql = $this->pdo->prepare($sql);
                if ($prepSql->execute($dataVenda)) {

                }

                if (empty($prodArray)) {
                    $textError = "Erro ao cadastrar o pedido! Nenhum produto encontrado.";
                    return $this->sendErrorMessage($textError);
                }

                foreach ($prodArray as $produtoId => $qtde) {
                    //ADICIONA PRODUTO NO CARRINHO
                    $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $produtoId . " AND usuario_id = " . $this->user['permissoes_id'];
                    $query = $this->pdo->query($sql);
                    $uV = $query->fetch();
                    $preco = $uV['valor'];
                    $quantidade = $qtde;
                    $subtotal = $preco * $quantidade;
                    $dataVenda = array(
                        ':quantidade' => $quantidade,
                        ':subTotal' => $subtotal,
                        ':produtos_id' => $produtoId,
                        ':vendas_id' => $vendaId,
                    );

                    $sql = "INSERT INTO itens_de_vendas (quantidade, subTotal, produtos_id, vendas_id) VALUES (:quantidade, :subTotal, :produtos_id, :vendas_id)";

                    if ($this->pdo->prepare($sql)->execute($dataVenda)) {

                        $novoEstoque = $produto['estoque'] - $quantidade;
                        $dataUpdate = array(
                            ':novoEstoque' => $novoEstoque,
                            ':produto_id' => $produtoId,
                        );

                        $sql = "UPDATE produtos set estoque = :novoEstoque WHERE idProdutos = :produto_id";

                        $prepSql = $this->pdo->prepare($sql);
                        if ($prepSql->execute($dataUpdate)) {

                            $this->notes['produto_id'] = null;
                            $this->conversation->update();

                            $sql = "SELECT  * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $vendaId";
                            $query = $this->pdo->query($sql);
                            $produtos = $query->fetchAll();
                            $rows = $query->rowCount();
                            $total = 0;
                            if ($rows > 0) {
                                $listProd = "";
                                foreach ($produtos as $produto) {
                                    $produto['subTotal'] = $produto['subTotal'];
                                    $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";
                                    $total += $produto['subTotal'];
                                }
                            }
                        }
                    }
                }
                $this->notes['dadosEnvio'] = $dados;
                $this->notes['vendaId'] = $vendaId;
                $this->conversation->update();

                $inline_keyboard = new InlineKeyboard();
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "Carta Registrada", 'callback_data' => 'Post_TipoEnvio_CARTA'
                ]));
                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => "Sedex", 'callback_data' => 'Post_TipoEnvio_SEDEX'
                ]));


                $text = "Pedido registrado!\nDados do Pedido: \n$dados\n\nProdutos:\n$listProd\nTotal sem o frete: R$$total\n\nAgora escolha o tipo de envio deste pedido";
                return $this->sendMessage($text, $inline_keyboard);


            } else {
                $textError = "Erro ao cadastrar o pedido!";
                return $this->sendErrorMessage($textError);
            }

        } else {

            $text = "\xE2\x9A\xA0 Ops, não consegui encontrar o seu CEP nos dados que você acabou de me enviar!.\n\nSó aceitamos CEP no seguinte formato:\n00000-000\nConfira os dados e clique em inserir dados novamente \n\nOu clique em voltar ao menu principal.";
            $this->sendMessage($text);
        }

    }

    public function PostComprovanteReprovacaoMotivo()
    {

        if (!empty($this->notes['comprovanteReprovado'])) {
            $comprovanteId = $this->notes['comprovanteReprovado'];
            $textMessage = trim($this->message->getText());

            $dataDivida = array(
                ':status' => 0,
                ':aguardando_pag' => 0,
                ':motivo_reprovacao' => $textMessage,
                ':id' => $comprovanteId,
            );

            $sql = "UPDATE dividas set status = :status, motivo_reprovacao = :motivo_reprovacao, aguardando_pag = :aguardando_pag  WHERE id = :id";
            $prepSql = $this->pdo->prepare($sql);
            if ($prepSql->execute($dataDivida)) {
                $inline_keyboard = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                );
                $text = "\xE2\x9D\x8C Comprovante #$comprovanteId reprovado!";

                $sql = "SELECT * FROM dividas WHERE id = {$comprovanteId}";
                $query = $this->pdo->query($sql);
                $divida = $query->fetch();
                //$this->user['chat_id'];

                $this->sendMessageById($this->user['chat_id'], $text, $inline_keyboard);
                //$this->sendMessage($text, $inline_keyboard);

                if (!empty($this->user['chat_id'])) {
                    //$text .= "\n\n\xE2\x9D\x8C Comprovante $comprovanteId reprovado!";
                    $text .= "\nValor: R$" . $divida['valor'];
                    $text .= "\n\n\xE2\x9A\xA0 Motivo \xE2\x9A\xA0\n";
                    $text .= $divida['motivo_reprovacao'];

                    $inline_keyboard_warnyj = new InlineKeyboard(
                        [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                    );

                    $sql = "SELECT * FROM usuarios WHERE idUsuarios = {$divida['enviador_id']}";
                    $query = $this->pdo->query($sql);
                    $enviador = $query->fetch();

                    Request::sendPhoto([
                        'caption' => $text,
                        'chat_id' => $enviador['chat_id'],
                        'photo' => $divida['comprovante'],
                        'reply_markup' => $inline_keyboard_warnyj,
                    ]);

                    //$this->sendMessageById($enviador['chat_id'], $text, $inline_keyboard_warnyj);
                }

            } else {
                $inline_keyboard = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                );
                $text = "Ocorreu um erro ao modificar o pedido.";
                $this->sendMessageById($this->user['chat_id'], $text, $inline_keyboard);
            }

        }

    }

    public function PostImagemProduto()
    {
        $message_type = $this->message->getType();

        if (in_array(strtolower($this->message->getType()), ['photo'])) {

            $doc = $this->message->{'get' . ucfirst($message_type)}();
            // For photos, get the best quality!
            ($message_type === 'photo') && $doc = end($doc);
            $file = Request::getFile(['file_id' => $doc->getFileId()]);

            if ($file->isOk()) {
                Request::downloadFile($file->getResult());
                $path = $file->getResult()->file_path;

                $complete_path = __DIR__ . "/../../assets/" . $path;

                $file_name = date('Ymis') . '.jpg';
                $new_path = __DIR__ . "/../../assets/imagem_produto/" . $file_name;
                $teste = __DIR__ . "/../../assets/imagem_produto/";


                if (rename($complete_path, $new_path)) {

                    //SALVOU O ARQUIVO!
                    $this->notes['arquivo'] = $new_path;
                    $this->notes['link'] = "https://receitasdarkblog.icu/market/assets/imagem_produto/$file_name";
                    //$this->notes['link'] = "https://receitasdarkblog.icu/market/assets/imagem_produto/$file_name";

                    $data = array(
                        ':descricao' => "Produto criado pelo usuario: " . $this->user['nome'],
                        ':status' => "0",
                        ':idFornecedor' => $this->user['idUsuarios'],
                        ':usuarioEnvio_id' => $this->user['idUsuarios'],
                        ':create_user_id' => $this->user['idUsuarios'],
                        ':imagem' => $this->notes['link'],
                        ':imagemCatalogo' => $this->notes['link'],
                        ':is_bot' => 1,
                    );
                    $sql = "INSERT INTO produtos (descricao, status, create_user_id, imagem, imagemCatalogo, is_bot, idFornecedor, usuarioEnvio_id) 
              VALUES (:descricao, :status, :create_user_id, :imagem, :imagemCatalogo, :is_bot, :idFornecedor, :usuarioEnvio_id)";


                    if ($this->pdo->prepare($sql)->execute($data)) {
                        $produto_id = $this->pdo->lastInsertId();
                        $text = "Informe agora o nome, descrição, quantidade minima e preço do Produto.\n\nExemplo:\n";
                        $text .= "Nome: Flor da Vida\n";
                        $text .= "Estoque: 1\n";
                        $text .= "\xE2\x9A\xA0 <i>(Veja quais estoques você pode usar)</i>\n";
                        $text .= "Descrição: LSD 200ug Needlepoint\n";
                        $text .= "Minimo: 1 cartela\n";
                        $text .= "Preço\n";
                        $text .= "de 1 a 4 = R$400 cada\n";
                        $text .= "de 5 a 10 = R$350 cada\n";
                        $text .= "\xE2\x9A\xA0 <i>(Favor inserir o valor por unidade)</i>\n\n";
                        $text .= "<b>Não esqueça que o valor é o preço que vai custar para o Rei dos Aditivos e não para o cliente final.</b>";

                        $this->notes['produto_id'] = $produto_id;
                        $this->notes['requestData'] = "PostDadosProdutos";
                        $this->conversation->update();
                        $this->sendMessage($text);


                    }


                } else {

                    $text = "Erro ao renomear o arquivo.";
                  //  $text = "Erro ao renomear o arquivo.\n\nComplete Path: $complete_path\n\nFile name: $file_name\n\nNew Path: $new_path";
                    $this->sendErrorMessage($text);
                }
            } else {
                $text = "Não consegui fazer o upload do arquivo.\n\n";
                $this->sendErrorMessage($text);
            }
        } else {
            $text = "Só são aceitos arquivos de imagem.\n\n";
            $this->sendErrorMessage($text);
        }
    }
    public function SolicitarSaqueConta(){
        $textMessage = trim($this->message->getText());
        if (is_numeric($textMessage)) {
            $this->notes['valorSaque'] = $textMessage;
            $this->notes['requestData'] = "CriarContaBancaria";
            $text = "\xF0\x9F\x92\xB0 Informe o PIX para receber?";
            $this->sendMessage($text);
        }
    }
    public function CriarContaBancaria(){
        try{
            $conta = trim($this->message->getText());
            $valorSaque = $this->notes['valorSaque'];
            $dataConta = array(
                ':nome' => "PIX",
                ':conta' => $conta,
                ':usuario_id' => $this->user['idUsuarios'],
                ':cadastro' => date('Y-m-d'),
                ':tipo' => "pix",
                ':status' => 0,
                ':valor_solicitado' => $valorSaque,
                ':valor_pago' => 0,
                ':valor_faltante' => $valorSaque,

            );
            $this->sendMessage(json_encode($dataConta));
            $sql = "INSERT INTO contas (nome, conta, usuario_id, cadastro, tipo, status, is_solicitacao, valor_solicitado, valor_pago, valor_faltante) VALUES (:nome, :conta, :usuario_id, :cadastro, :tipo, :status, 1, :valor_solicitado, :valor_pago, :valor_faltante)";
            $this->sendMessage($sql);
            if ($this->pdo->prepare($sql)->execute($dataConta)) {
                $this->sendMessage(2);
                $contaId = $this->pdo->lastInsertId();
                $textWarnyj = "Solicitação pagamento\n\n" . $this->user['nome']."\nValor: R$" . $valorSaque . "\n\n";
                $textWarnyj .= $conta;

                //617711684
                //ENVIAR PEDIDO O ADM
                $inline_keyboard_warnyj = new InlineKeyboard(
                    [['text' => "\xE2\x9C\x85 Aprovar solicitação", 'callback_data' => "Aprovar_Conta_$contaId"]],
                    [['text' => "\xE2\x9D\x8C Reprovar solicitação", 'callback_data' => "Reprovar_Conta_$contaId"]]
                );

                $this->sendMessageById(889423113, $textWarnyj, $inline_keyboard_warnyj);


                $text = "Aguarde a aprovação pelo Administrador";
                $this->sendMessage($text);
            }else{

            }
        }catch (\PDOException $e){
            $this->sendMessageById(889423113, $e->getMessage());

        }

    }
    public function PostDadosProdutos()
    {
        $fornecedor_id = $this->user['idUsuarios'];
        $textMessage = addslashes($this->message->getText());
        $produto_id = $this->notes['produto_id'];
        $dataProduto = array(
            ':observacao' => $textMessage,
            ':idFornecedor' => $fornecedor_id,
            ':usuarioEnvio_id' => $fornecedor_id,
            ':produto_id' => $produto_id,

        );
        $sql = "UPDATE produtos set observacao = :observacao, idFornecedor = :idFornecedor, usuarioEnvio_id = :usuarioEnvio_id WHERE idProdutos = :produto_id";

        $prepSql = $this->pdo->prepare($sql);
        if ($prepSql->execute($dataProduto)) {
            $prodId = $this->pdo->lastInsertId();
            $inline_keyboard_aviso = new InlineKeyboard();

            $inline_keyboard_aviso->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\xA5 Publicar produto", 'callback_data' => "Publicar_Produto_" . $prodId
            ]));

            $inline_keyboard_aviso->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"
            ]));

            $texto_aviso = "Novo produto: #" . $produto_id . "\n\nProduto inserido por " . $this->user['nome'] . "\n$textMessage";



                Request::sendPhoto([
                'chat_id' => 889423113,
                'caption' => $texto_aviso,
                'photo' => Request::encodeFile($this->notes['link']),
                'reply_markup' => $inline_keyboard_aviso,
                'resize_keyboard' => true,
                'parse_mode' => 'HTML',

            ]);

            $inline_keyboard = new InlineKeyboard();
            $text = "\xE2\x9C\x85 Produto inserido com sucesso!\nAguarde aprovação pelo administrador!";

            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x8F\xA2 \xF0\x9F\x92\xB0 Voltar - Painel de Fornecedor \xF0\x9F\x92\xB0 \xF0\x9F\x8F\xA2 ", 'callback_data' => "Lista_ProdutosFornecedor"
            ]));

            $this->sendMessage($text, $inline_keyboard);


            //REMOVENDO PRODUTO PARA NAO POLUIR O BOT!
            $dataDeleteProduto = array('produto_id'=>$produto_id);
            $sql = "DELETE FROM produtos WHERE idProdutos = :produto_id";
            $this->pdo->prepare($sql)->execute($dataDeleteProduto);
        }
    }

    public function CadastroProduto()
    {
        if ($this->user['permissoes_id'] == 1) {
            $produto_id = $this->notes['produto_id'];
            $textMessage = $this->message->getText();
            $itensCadastro = explode("\n", $textMessage);
            if ($itensCadastro[3] == "S") {
                $pesado = 1;
            } else {
                $pesado = 0;
            }

            $dataProduto = array(
                ':idProdutos' => $produto_id,
                ':descricao' => $itensCadastro[0],
                ':nomeCatalogo' => $itensCadastro[1],
                ':descricaoCatalogo' => $itensCadastro[2],
                ':pesado' => $pesado,
                ':unidade' => $itensCadastro[4],
                ':produto_confiavel' => $itensCadastro[5],
            );
            $sql = "UPDATE produtos set descricao = :descricao, nomeCatalogo = :nomeCatalogo, 
                    descricaoCatalogo = :descricaoCatalogo, pesado = :pesado,
                    unidade = :unidade, produto_confiavel = :produto_confiavel
                WHERE idProdutos = :idProdutos";
            $prepSql = $this->pdo->prepare($sql);
            if ($prepSql->execute($dataProduto)) {

                $sql = "SELECT * FROM produtos WHERE idProdutos = $produto_id";
                $query = $this->pdo->query($sql);
                $produto = $query->fetch();

                $texto = "Publicar produto: \n" . $produto['observacao'];
                $texto .= "\n\n";

                $texto .= "Agora precifique o produto para o Admin os seguintes dados do produto:\n\n";
                $texto .= "Me envie no seguinte formato:\n\n";
                $texto .= "1-3=100\n";
                $texto .= "4-9=80\n";

                // 1 - ADMINISTRADOR
                $this->notes['permissao_precificacao'] = 1;
                $this->notes['produto_id'] = $produto_id;
                $this->notes['requestData'] = "PrecificarAdmin";
                $this->conversation->update();
                $inline_keyboard = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x94\x99 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu']]
                );
                Request::sendPhoto([
                    'chat_id' => 889423113,
                    'caption' => $texto,
                    'photo' => Request::encodeFile($produto['imagem']),
                    'reply_markup' => $inline_keyboard,
                    'resize_keyboard' => true
                ]);
            }
        }

    }

    public function CadastrarLinhasValor($textMessage){
        $linhas = explode("\n", $textMessage);
        $permissao_precificacao = $this->notes['permissao_precificacao'];

        $produto_id = $this->notes['produto_id'];

        foreach ($linhas as $linha) {
            // Separa os campos de cada linha em um array
            $campos = explode("=", $linha);

            // Monta o novo array com a estrutura desejada
            $intervalo = explode("-", $campos[0]);
            $de = $intervalo[0];
            $ate = $intervalo[1];
            $valor = $campos[1];


            $dataValor = array(
                ':de' => $de,
                ':ate' => $ate,
                ':usuario_id' => $permissao_precificacao,
                ':produto_id' => $produto_id,
                ':valor' => $valor,
                ':quantidade_vendido' => 0,
            );

            $sql = "INSERT INTO usuario_valor (de, ate, usuario_id, produto_id, valor, quantidade_vendido) 
VALUES (:de, :ate, :usuario_id, :produto_id, :valor, :quantidade_vendido)";


            $this->pdo->prepare($sql)->execute($dataValor);

            if($permissao_precificacao == 1){
                $dataValor['usuario_id'] = 2;
                $sql = "INSERT INTO usuario_valor (de, ate, usuario_id, produto_id, valor, quantidade_vendido) 
VALUES (:de, :ate, :usuario_id, :produto_id, :valor, :quantidade_vendido)";

                $this->pdo->prepare($sql)->execute($dataValor);
            }
        }
    }

    public function getValorByPordutoPermissao($produto, $permissao_id){

        $unidade = $produto['unidade'];

        $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $produto['idProdutos'] . " AND usuario_id = " . $permissao_id . " ORDER BY de ASC";
        $query = $this->pdo->query($sql);
        $valores = $query->fetchAll();
        $text = "";
        foreach ($valores as $valor) {
            $preco = $valor['valor'];
            $de = $valor['de'];
            $ate = $valor['ate'];

            $text .= "de $de" . $unidade . " até $ate" . $unidade . " = R$" . $preco . "\n";

        }
        $text .= "-\n";
        return $text;
    }
    public function PrecificarAdmin()
    {
        $textMessage = $this->message->getText();
        $produto_id = $this->notes['produto_id'];

        $this->CadastrarLinhasValor($textMessage);

        $sql = "SELECT * FROM produtos WHERE idProdutos = $produto_id";

        $query = $this->pdo->query($sql);
        $produto = $query->fetch();

        $texto = "Publicar produto: \n" . $produto['observacao'];
        $texto .= "\n\n";
        $texto .= "Valor de Custo:\n";
        $textoValorAdmin = $this->getValorByPordutoPermissao($produto, 1);
        $texto .= $textoValorAdmin;
        $texto .= "\n\n";

        $texto .= "Agora precifique o produto para o Super Vendedor os seguintes dados do produto:\n";

        // 1 - ADMINISTRADOR
        $this->notes['permissao_precificacao'] = 3;
        $this->notes['produto_id'] = $produto_id;
        $this->notes['requestData'] = "PrecififcarSuperVendedor";
        $this->conversation->update();

        Request::sendPhoto([
            'chat_id' => 889423113,
            'caption' => $texto,
            'photo' => Request::encodeFile($produto['imagem']),
            //'reply_markup' => $inline_keyboard_aviso,
            'resize_keyboard' => true,
            'parse_mode' => 'HTML',
        ]);
        $permissao_precificacao = $this->notes['permissao_precificacao'];
        $produto_id = $this->notes['produto_id'];

    }

    public function PrecififcarSuperVendedor()
    {
        $textMessage = $this->message->getText();
        $produto_id = $this->notes['produto_id'];

        $this->CadastrarLinhasValor($textMessage);

        $sql = "SELECT * FROM produtos WHERE idProdutos = $produto_id";
        $query = $this->pdo->query($sql);
        $produto = $query->fetch();

        $texto = "Publicar produto: \n" . $produto['descricao'];
        $texto .= "\n\n";
        $texto .= "Valor de Custo:\n";
        $textoValor = $this->getValorByPordutoPermissao($produto, 1);
        $textoValor .= "Valor Super Vendedor:\n";
        $textoValor .= $this->getValorByPordutoPermissao($produto, 3);
        $texto .= $textoValor;
        $texto .= "\n\n";

        $texto .= "Agora precifique o produto para o Telecrazy os seguintes dados do produto:\n";

        // 1 - ADMINISTRADOR
        $this->notes['permissao_precificacao'] = 4;
        $this->notes['produto_id'] = $produto_id;
        $this->notes['requestData'] = "PrecificarTelecrazy";
        $this->conversation->update();
        $inline_keyboard = new InlineKeyboard(
            [['text' => "\xF0\x9F\x94\x99 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu']]
        );
        Request::sendPhoto([
            'chat_id' => 889423113,
            'caption' => $texto,
            'photo' => Request::encodeFile($produto['imagem']),
            'reply_markup' => $inline_keyboard,
            'resize_keyboard' => true
        ]);


    }

    public function PrecificarTelecrazy()
    {
        $textMessage = $this->message->getText();
        $produto_id = $this->notes['produto_id'];

        $this->CadastrarLinhasValor($textMessage);

        $sql = "SELECT * FROM produtos WHERE idProdutos = $produto_id";
        $query = $this->pdo->query($sql);
        $produto = $query->fetch();

        $texto = "Publicar produto: \n" . $produto['descricao'];
        $texto .= "\n\n";
        $texto .= "Valor de Custo:\n";
        $textoValor = $this->getValorByPordutoPermissao($produto, 1);
        $textoValor .= "Valor Super Vendedor:\n";
        $textoValor .= $this->getValorByPordutoPermissao($produto, 3);
        $textoValor .= "Valor Telecrazy:\n";
        $textoValor .= $this->getValorByPordutoPermissao($produto, 4);

        $texto .= $textoValor;
        $texto .= "\n\n";

        $texto .= "Agora precifique o produto para o os clientes finais :\n";

        // 1 - ADMINISTRADOR
        $this->notes['permissao_precificacao'] = 6;
        $this->notes['produto_id'] = $produto_id;
        $this->notes['requestData'] = "PrecificarFinal";
        $this->conversation->update();
        $inline_keyboard = new InlineKeyboard(
            [['text' => "\xF0\x9F\x94\x99 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu']]
        );
        Request::sendPhoto([
            'chat_id' => 889423113,
            'caption' => $texto,
            'photo' => Request::encodeFile($produto['imagem']),
            'reply_markup' => $inline_keyboard,
            'resize_keyboard' => true,
            'parse_mode' => 'HTML',
        ]);


    }

    public function PrecificarFinal()
    {

        $textMessage = $this->message->getText();
        $produto_id = $this->notes['produto_id'];

        $this->CadastrarLinhasValor($textMessage);

        $sql = "SELECT * FROM produtos WHERE idProdutos = $produto_id";
        $query = $this->pdo->query($sql);
        $produto = $query->fetch();


        $texto = "Publicar produto: \n" . $produto['descricao'];
        $texto .= "\n\n";
        $texto .= "Valor de Custo:\n";
        $textoValor = $this->getValorByPordutoPermissao($produto, 1);
        $textoValor .= "Valor Super Vendedor:\n";
        $textoValor .= $this->getValorByPordutoPermissao($produto, 3);
        $textoValor .= "Valor Telecrazy:\n";
        $textoValor .= $this->getValorByPordutoPermissao($produto, 4);
        $textoValor .= "Valor Cliente Final:\n";
        $textoValor .= $this->getValorByPordutoPermissao($produto, 6);
        $texto .= $textoValor;
        $texto .= "\n\n";

        $texto .= "Agora informe a descricao:\n";

        $this->notes['permissao_precificacao'] = null;
        $this->notes['produto_id'] = $produto_id;
        $this->notes['requestData'] = "CadastroProdutoObservacao";
        $this->conversation->update();
        $inline_keyboard = new InlineKeyboard(
            [['text' => "\xF0\x9F\x94\x99 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu']]
        );
        Request::sendPhoto([
            'chat_id' => 889423113,
            'caption' => $texto,
            'photo' => Request::encodeFile($produto['imagem']),
            'reply_markup' => $inline_keyboard,
            'resize_keyboard' => true,
            'parse_mode' => 'HTML',
        ]);
        $permissao_precificacao = $this->notes['permissao_precificacao'];
        $produto_id = $this->notes['produto_id'];

    }

    public function CadastroProdutoObservacao(){

        $textMessage = $this->message->getText();
        $produto_id = $this->notes['produto_id'];

        $sql = "SELECT * FROM produtos WHERE idProdutos = $produto_id";
        $query = $this->pdo->query($sql);
        $produto = $query->fetch();

        $dataProduto = array(
            ':observacao' =>   $textMessage,
            ':produto_id' =>   $produto_id,
        );
        $sql = "UPDATE produtos set observacao = :observacao WHERE idProdutos = :produto_id";
        $texto = "";
        $prepSql = $this->pdo->prepare($sql);
        if ($prepSql->execute($dataProduto)) {

            $sql = "SELECT * FROM tipo_produto WHERE status = 1 ORDER BY ordem ASC";
            $query = $this->pdo->query($sql);
            $tipos = $query->fetchAll();
            $inline_keyboard = new InlineKeyboard();
            foreach ($tipos as $tipo) {
                $icone = $this->SelecionaIcone($tipo['id']);

                $inline_keyboard->addRow(new InlineKeyboardButton([
                    'text' => $icone . " " . $tipo['nome'] . " " . $icone,
                    'callback_data' => "CadastrarProduto_Tipo_" . $tipo['id']
                ]));
            }
            $this->notes['requestData'] = null;
            $this->conversation->update();
            $texto .= "Agora selecione o tipo do produto ".$produto['nome'].": \n";

            Request::sendPhoto([
                'chat_id' => 889423113,
                'caption' => $texto,
                'photo' => Request::encodeFile($produto['imagem']),
                'reply_markup' => $inline_keyboard,
                'resize_keyboard' => true,
                'parse_mode' => 'HTML',
            ]);
        }
    }
    public function PostComprovante()
    {
        $message_type = $this->message->getType();

        if (in_array(strtolower($this->message->getType()), ['photo'])) {

            $doc = $this->message->{'get' . ucfirst($message_type)}();
            // For photos, get the best quality!
            ($message_type === 'photo') && $doc = end($doc);
            $file = Request::getFile(['file_id' => $doc->getFileId()]);

            if ($file->isOk()) {
                Request::downloadFile($file->getResult());
                $path = $file->getResult()->file_path;

                $complete_path = __DIR__ . "/../../assets/" . $path;

                $file_name = date('Ymis') . '.jpg';
                $new_path = __DIR__ . "/../../assets/comprovantes/photos/" . $file_name;
                $teste = __DIR__ . "/../../assets/comprovantes/photos/";

                if (rename($complete_path, $new_path)) {
                    //SALVOU O ARQUIVO!
                    $this->notes['arquivo'] = $new_path;
                    //$this->notes['link'] = "https://receitasdarkblog.icu/market/assets/comprovantes/photos/$file_name";
                    $this->notes['link'] = "https://receitasdarkblog.icu/market/assets/comprovantes/photos/$file_name";

                    if (empty($this->notes['dividaId'])) {
                        if (!empty($this->notes['vendaId'])) {
                            $vendaId = $this->notes['vendaId'];
                            $dataVenda = array(
                                ':imagem_comprovante' => $this->notes['link'],
                                ':vendaId' => $vendaId,
                            );
                            $sql = "UPDATE vendas set imagem_comprovante = :imagem_comprovante WHERE idVendas = :vendaId";
                            $prepSql = $this->pdo->prepare($sql);
                            $prepSql->execute($dataVenda);
                            $inline_keyboard = new InlineKeyboard(
                                [['text' => "\xE2\x9C\x85 Faturar pedido", 'callback_data' => 'Faturar_Pedido']],
                                [['text' => 'Enviar pagamento deste pedido', 'callback_data' => 'Input_ValorComprovante']],
                                [['text' => "\xE2\x9D\x8C Cancelar Pedido", 'callback_data' => 'Main_CancelarVenda']]
                            );
                        } else {
                            $vendaId = null;
                            $inline_keyboard = new InlineKeyboard();
                        }
                        if (!empty($this->notes['usuarioComprovante']) && $this->notes['usuarioComprovante'] <> $this->user['idUsuarios']) {

                            $usuarioComprovante = $this->notes['usuarioComprovante'];

                            //GRAVANDO DIVIDA
                            $dataDividas = array(
                                ':data' => date('Y-m-d'),
                                ':enviador_id' => $this->user['idUsuarios'],
                                ':recebedor_id' => $usuarioComprovante,
                                ':valor' => $this->notes['valorTotal'],
                                ':descricao' => "Comprovante enviado via Telegram",
                                ':tipo' => "POSITIVO",
                                ':comprovante' => $this->notes['link'],
                            );


                            $valorTotal = $this->notes['valorTotal'];
                            if (!empty($vendaId)) {
                                $dataDividas[':venda_id'] = $vendaId;
                                $sql = "INSERT INTO dividas (data, enviador_id, recebedor_id, valor, descricao, tipo, comprovante, venda_id, status) VALUES (:data, :enviador_id, :recebedor_id, :valor, :descricao, :tipo, :comprovante, :venda_id, 0)";
                            } else {
                                $this->notes['valorTotal'] = NULL;
                                $sql = "INSERT INTO dividas (data, enviador_id, recebedor_id, valor, descricao, tipo, comprovante, status) VALUES (:data, :enviador_id, :recebedor_id, :valor, :descricao, :tipo, :comprovante, 0)";
                            }
                            if ($this->pdo->prepare($sql)->execute($dataDividas)) {
                                $dividaId = $this->pdo->lastInsertId();

                                $inline_keyboard_comprovante = new InlineKeyboard(
                                    [['text' => "\xE2\x9C\x85 Aprovar comprovante", 'callback_data' => 'Aprovar_Comprovante_' . $dividaId]],
                                    [['text' => "\xE2\x9D\x8C Reprovar comprovante", 'callback_data' => 'Reprovar_Comprovante_' . $dividaId]]
                                );
                                Request::sendPhoto([
                                    'chat_id' => 889423113,
                                    'caption' => 'Comprovante enviado por ' . $this->user['nome'] . "\nValor informado: R$" . $valorTotal . "\nDono da conta: R$" . "\nDívida #$dividaId",
                                    'photo' => Request::encodeFile($this->notes['arquivo']),
                                    'reply_markup' => $inline_keyboard_comprovante,
                                    'resize_keyboard' => true,
                                    'parse_mode' => 'HTML',
                                ]);

                                $this->notes['requestData'] = null;

                                $notes['arquivo'] = null;
                                $notes['link'] = null;
                                $this->conversation->update();

                                $text = "\xE2\x9C\x85 Comprovante enviado com sucesso!\nAguarde ele ser validado para que o saldo entre na sua conta.";
                                $this->sendMessage($text, $inline_keyboard);

                            }


                        }
                    } else {
                        $vendaId = $this->notes['vendaId'];
                        $dataVenda = array(
                            ':imagem_comprovante' => $this->notes['link'],
                            ':vendaId' => $vendaId,
                        );
                        $sql = "UPDATE vendas set imagem_comprovante = :imagem_comprovante WHERE idVendas = :vendaId";
                        $prepSql = $this->pdo->prepare($sql);
                        $prepSql->execute($dataVenda);


                        //----

                        $dividaId = $this->notes['dividaId'];

                        $dataHoje = date('d/m/Y');
                        $dataDivida = array(
                            ':dividaId' => $dividaId,
                            ':comprovante' => $this->notes['link'],
                            ':descricao' => "Enviado por: " . $this->user['nome'] . "\nComprovante enviado via Telegram.\nData: " . $dataHoje . "\nValor: R$" . $this->notes['valorTotal'],
                        );
                        $sql = "UPDATE dividas set descricao = :descricao, comprovante = :comprovante WHERE id = :dividaId";
                        $prepSql = $this->pdo->prepare($sql);
                        if ($prepSql->execute($dataDivida)) {

                            $inline_keyboard_comprovante = new InlineKeyboard(
                                [['text' => "\xE2\x9C\x85 Aprovar comprovante", 'callback_data' => 'Aprovar_Comprovante_' . $dividaId]],
                                [['text' => "\xE2\x9D\x8C Reprovar comprovante", 'callback_data' => 'Reprovar_Comprovante_' . $dividaId]]
                            );
                            Request::sendPhoto([
                                'chat_id' => 889423113,
                                'caption' => 'Comprovante enviado por ' . $this->user['nome'] . "\nValor informado: R$" . $this->notes['valorTotal'] . "\nDívida #$dividaId",
                                'photo' => Request::encodeFile($this->notes['arquivo']),
                                'reply_markup' => $inline_keyboard_comprovante,
                                'resize_keyboard' => true,
                                'parse_mode' => 'HTML',
                            ]);

                            $this->notes['requestData'] = null;

                            $notes['arquivo'] = null;
                            $notes['link'] = null;
                            $this->conversation->update();

                            $text = "\xE2\x9C\x85 Comprovante enviado com sucesso!\nAguarde ele ser validado para que o saldo entre na sua conta.";
                            $this->sendMessage($text);
                        }

                    }


                } else {

                    $text = "Erro ao renomear o arquivo.";
                    $text = "Erro ao renomear o arquivo.\n\nComplete Path: $complete_path\n\nFile name: $file_name\n\nNew Path: $new_path";
                    $this->sendErrorMessage($text);
                }
            } else {
                $text = "Não consegui fazer o upload do arquivo.\n\n";
                $this->sendErrorMessage($text);
            }
        } else {
            $text = "Só são aceitos arquivos de imagem.\n\n";
            $this->sendErrorMessage($text);
        }
    }

    public function UploadSRO()
    {
        $message_type = $this->message->getType();
        if (in_array(strtolower($this->message->getType()), ['photo'])) {

            $doc = $this->message->{'get' . ucfirst($message_type)}();

            // For photos, get the best quality!
            ($message_type === 'photo') && $doc = end($doc);
            $file = Request::getFile(['file_id' => $doc->getFileId()]);

            if ($file->isOk()) {
                Request::downloadFile($file->getResult());

                $path = $file->getResult()->file_path;
                $complete_path = __DIR__ . "/../../assets/" . $path;
                $file_name = date('Ymis') . '.jpg';
                $new_path = __DIR__ . "/../../assets/sro/photos/" . $file_name;

                if (rename($complete_path, $new_path)) {
                    $this->notes['arquivo'] = $new_path;
                    //$this->notes['link'] = "https://receitasdarkblog.icu/market/assets/sro/photos/$file_name";
                    $this->notes['link'] = "https://receitasdarkblog.icu/market/assets/sro/photos/$file_name";

                    $this->conversation->update();

                    $sql = "SELECT * FROM vendas WHERE faturado = 1 AND status = 2 AND enviador_id = {$this->user['idUsuarios']}";

                    $query = $this->pdo->query($sql);
                    $vendas = $query->fetchAll();
                    $rows = $query->rowCount();

                    $inline_keyboard = new InlineKeyboard();
                    if ($rows > 0) {
                        $inlineItens = array();
                        $i = 0;

                        foreach ($vendas as $venda) {

                            $inline_keyboard->addRow(new InlineKeyboardButton([
                                'text' => '#' . $venda['idVendas'] . " - " . $venda['cep'],
                                'callback_data' => "Envia_SRO_" . $venda['idVendas']
                            ]));

                        }
                        $inline_keyboard->addRow(new InlineKeyboardButton([
                            'text' => "Cancelar envio do SRO",
                            'callback_data' => "Cancelar_EnvioSRO"
                        ]));

                        $text = "Selecione o pedido referente a este SRO";
                        $this->sendMessage($text, $inline_keyboard);

                    } else {

                        $text = "Nenhum pedido pendente encontrado!";

                        $this->sendMessage($text);

                    }
                } else {

                    $text = "Erro ao fazer upload do arquivo.";
                    $this->sendErrorMessage($text);
                }


            } else {

                $text = "Erro ao fazer upload do arquivo. (File)";
                $this->sendErrorMessage($text);
            }
        } else {
            $text = "Só são aceitos arquivos de imagem.";
            $this->sendErrorMessage($text);
        }
    }

    public function informarQuantidadeProduto()
    {

        $produtoId = $this->notes['produto_id'];
        $vendaId = $this->notes['vendaId'];
        $textMessage = trim($this->message->getText());
        $idUsuario = $this->user['idUsuarios'];
        $sql = "SELECT * FROM produtos WHERE idProdutos = {$produtoId}";
        $query = $this->pdo->query($sql);
        $produto = $query->fetch();

        $sql = "SELECT * FROM vendas WHERE idVendas = {$vendaId}";
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();
        if (!empty($produto)) {
            if (is_numeric($textMessage)) {

                //ADICIONA PRODUTO NO CARRINHO
                $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $produto['idProdutos'] . " AND usuario_id = " . $this->user['permissoes_id'] . " AND de <= $textMessage AND ate >= $textMessage";
                $query = $this->pdo->query($sql);
                $uV = $query->fetch();
                if (!empty($uV)) {

                    $preco = $uV['valor'];
                    $quantidade = $textMessage;
                    $subtotal = $preco * $quantidade;

                    $sql = "SELECT * FROM usuario_valor WHERE produto_id = " . $produto['idProdutos'] . " AND usuario_id = 1 AND de <= $textMessage AND ate >= $textMessage";
                    $query = $this->pdo->query($sql);
                    $custo = $query->fetch();

                    $totalCusto = $custo['valor'] * $quantidade;

                    $dataVenda = array(
                        ':quantidade' => $quantidade,
                        ':subTotal' => $subtotal,
                        ':produtos_id' => $produtoId,
                        ':vendas_id' => $vendaId,
                        ':valorUnidade' => $preco,
                        ':totalCusto' => $totalCusto,
                    );

                    $sql = "INSERT INTO itens_de_vendas (quantidade, subTotal, produtos_id, vendas_id, valorUnidade, totalCusto) VALUES (:quantidade, :subTotal, :produtos_id, :vendas_id, :valorUnidade, :totalCusto)";

                    if ($this->pdo->prepare($sql)->execute($dataVenda)) {

                        /*
                                       $novoEstoque = $produto['estoque'] - $quantidade;
                                      $dataUpdate = array(
                                          ':novoEstoque' => $novoEstoque,
                                          ':produto_id' => $produtoId,
                                      );

                                      $sql = "UPDATE produtos set estoque = :novoEstoque WHERE idProdutos = :produto_id";

                                      $prepSql = $this->pdo->prepare($sql);
                                      if ($prepSql->execute($dataUpdate)) {}
                         */

                        $this->notes['produto_id'] = null;
                        $this->conversation->update();

                        $sql = "SELECT  * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $vendaId";
                        $query = $this->pdo->query($sql);
                        $produtos = $query->fetchAll();
                        $rows = $query->rowCount();
                        $total = 0;
                        $pedidoPesado = 0;
                        if ($rows > 0) {
                            $listProd = "";
                            foreach ($produtos as $produto) {
                                if ($produto['pesado'] == 1) {
                                    $pedidoPesado = 1;
                                }
                                $produto['subTotal'] = $produto['subTotal'];
                                $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : Cada: R$<b>" . $produto['valorUnidade'] . "</b> - Subtotal: <b>R$" . $produto['subTotal'] . "</b>\n";
                                $total += $produto['subTotal'];
                            }
                        }
                        $this->notes['pedidoPesado'] = $pedidoPesado;
                        $this->conversation->update();
                        $inline_keyboard = new InlineKeyboard(
                            [['text' => "\xF0\x9F\x9A\x9A Escolher Frete \xF0\x9F\x9A\x9A", 'callback_data' => 'Selecionar_TipoEnvio']],
                            [['text' => "\xE2\x9E\x95 Adicionar outro produto \xE2\x9E\x95", 'callback_data' => "Post_Categoria_" . $this->notes['categoria_id']]],
                            [['text' => "\xE2\x9D\x8C Cancelar Pedido \xE2\x9D\x8C", 'callback_data' => 'Main_CancelarVenda']]
                        );
                        $return_text = "Pedido: #$vendaId\n\xE2\x9C\x85 Produto adicionado com sucesso!\nProdutos no carrinho:\nQuantidade - Nome : Valor\n" .
                            $listProd . "\n<b>Total sem Frete: R$" . $total . "</b>\n\n\xE2\x9A\xA0 Em caso de erro, cancele o pedido!\nO que deseja fazer?";

                        $this->sendMessage($return_text, $inline_keyboard);

                    }
                } else {

                    $sql = "SELECT * FROM usuarios WHERE idUsuarios = {$idUsuario}";
                    $query = $this->pdo->query($sql);
                    $user = $query->fetch();
                    $idPermissao = $user['permissoes_id'];

                    $sql = "SELECT * FROM usuario_valor WHERE usuario_id = {$idPermissao} AND produto_id = {$produto['idProdutos']} ORDER BY de ASC";
                    $query = $this->pdo->query($sql);
                    $valores = $query->fetchAll();

                    $text = "Produto: <b>" . $produto['descricao'] . "</b>\n\n";
                    foreach ($valores as $v) {

                        $text .= "de " . $v['de'] . " até " . $v['ate'] . " = <b>R$" . $v['valor'] . "</b>\n";
                    }
                    $return_text = "<b>\xF0\x9F\x9A\xAB A quantidade selecionada não é válida!</b>\n\n{$text}\nInforme a quantidade de <b>" . $produto['descricao'] . "</b> que foi que você deseja comprar";
                    $this->sendMessage($return_text);
                }

            } else {
                $return_text = "A quantidade de produto vendido deve ser um numero inteiro!\nInforme a quantidade de <b>" . $produto['descricao'] . "</b> que foi que você deseja comprar";
                $this->sendMessage($return_text);
            }

        }
    }

    public function ConfirmarDados()
    {
        $vendaId = $this->notes['vendaId'];

        $sql = "SELECT * FROM vendas WHERE idVendas = {$vendaId}";
        $query = $this->pdo->query($sql);
        $venda = $query->fetch();

        $tipo_envio = $venda['tipoEnvio'];

        if ($tipo_envio == "SEDEX") {
            $valor_envio = 100;
        } else if ($tipo_envio == "CARTA") {
            $valor_envio = 50;
        }
        $this->notes['valor_envio'] = $valor_envio;
        $this->conversation->update();

        $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $vendaId";
        $query = $this->pdo->query($sql);
        $produtos = $query->fetchAll();
        $rows = $query->rowCount();
        $total = 0;
        if ($rows > 0) {
            $listProd = "";
            foreach ($produtos as $produto) {
                $produto['subTotal'] = $produto['subTotal'];
                $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";
                $total += $produto['subTotal'];
                $total += $produto['subTotal'];
            }
        }
        $total += $valor_envio;

        $inline_keyboard = new InlineKeyboard(
            [['text' => "\xE2\x9C\x85 Faturar pedido", 'callback_data' => "Faturar_Pedido"]],
            //[['text' => 'Enviar pagamento deste pedido', 'callback_data' => 'Input_ValorComprovante']],
            [['text' => "\xE2\x9D\x8C Cancelar Pedido", 'callback_data' => "Main_CancelarVenda"]]
        );
        $text = "\xF0\x9F\x9A\xA8 ATENÇÃO! \xF0\x9F\x9A\xA8\n\nConfira os dados de envio, e produtos selecionados!\n\xF0\x9F\x9A\xA8 PEDIDOS COM PRODUTOS NÃO CADASTRADOS NÃO SERÃO ACEITOS! \xF0\x9F\x9A\xA8\n\n" . $this->notes['dadosEnvio']
            . "\n-----------------------------------------\n\n#$vendaId\nProdutos no carrinho:\n\nQuantidade - Nome : Valor\n" .
            $listProd . "\nTipo de Envio: $tipo_envio - R$$valor_envio\nTotal com Frete: R$" .
            $total;
        if (($this->user['controle_completo'] == 1)) {
            $text .= "\n\nTotal informado de depósito: R$" . $this->notes['valorTotal'] . "\n";
        }

        $text .= "\n\xF0\x9F\x9A\xA8 Confira todos os dados! \xF0\x9F\x9A\xA8\n\nO que deseja fazer?";
        return $this->sendMessage($text, $inline_keyboard);
    }

    public function PostReprovacaoMotivo($textMessage)
    {

        if (!empty($this->notes['pedidoReprovado'])) {
            $vendaId = $this->notes['pedidoReprovado'];
            //$textMessage = trim($this->message->getText());

            $dataVenda = array(
                ':status' => 0,
                ':motivo_reprovacao' => $textMessage,
                ':vendaId' => $vendaId,
            );

            $sql = "UPDATE vendas set status = :status, motivo_reprovacao = :motivo_reprovacao  WHERE idVendas = :vendaId";
            $prepSql = $this->pdo->prepare($sql);
            if ($prepSql->execute($dataVenda)) {
                $inline_keyboard = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                );
                $text = "\xE2\x9D\x8C Pedido $vendaId reprovado!";

                $sql = "SELECT * FROM vendas WHERE idVendas = {$vendaId}";
                $query = $this->pdo->query($sql);
                $venda = $query->fetch();

                $sql = "SELECT * FROM usuarios WHERE idUsuarios = " . $venda['usuarios_id'];
                $query = $this->pdo->query($sql);
                $user = $query->fetch();

                //$this->deleteMessage($this->notes['msgDadosEnvioId']);
                $this->sendMessage($text, $inline_keyboard);

                if (!empty($user['chat_id'])) {
                    $text .= "\n\n" . $venda['dadosEnvio'];
                    $text .= "\n\n\xE2\x9D\x8C Pedido $vendaId reprovado!";
                    $text .= "\n\n\xE2\x9A\xA0Motivo\xE2\x9A\xA0\n";
                    $text .= $venda['motivo_reprovacao'];

                    $inline_keyboard_warnyj = new InlineKeyboard(
                        [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                    );

                    $this->sendMessageById($user['chat_id'], $text, $inline_keyboard_warnyj);

                }

            } else {
                $inline_keyboard = new InlineKeyboard(
                    [['text' => "\xF0\x9F\x93\xA5 Excluir aviso", 'callback_data' => "Excluir_Aviso"]]
                );
                $text = "Ocorreu um erro ao modificar o pedido.";
                $this->sendMessage($text, $inline_keyboard);
            }

        }
    }


    public function solicitarValor()
    {
        $textMessage = trim($this->message->getText());

        //$this->sendMessage(json_encode($this->notes));
        if (is_numeric($textMessage)) {
            if ($this->notes['vendaId']) {
                $vendaId = $this->notes['vendaId'];

                $sql = "SELECT * FROM vendas WHERE idVendas = {$vendaId}";
                $query = $this->pdo->query($sql);
                $venda = $query->fetch();
                $dataVenda = array(
                    ':valorTotal' => $textMessage,
                    ':vendaId' => $vendaId,
                );
                $sql = "UPDATE vendas set valorTotal = :valorTotal WHERE idVendas = :vendaId";

                $prepSql = $this->pdo->prepare($sql);
                if ($prepSql->execute($dataVenda)) {

                    $this->notes['requestData'] = null;
                    $this->notes['valorTotal'] = $textMessage;
                    $this->conversation->update();
                    $this->ConfirmarDados();
                }
            } else {

                $this->notes['valorTotal'] = $textMessage;
                $this->notes['requestData'] = "PostComprovante";
                $this->conversation->update();

                $text = "Legal!!!! Me envie a foto do comprovante. \xF0\x9F\x93\xB7";
                $this->sendMessage($text);

            }
        } else {
            $return_text = "O valor deve ser um número inteiro!\n\xF0\x9F\x92\xB0 Informe o valor que foi depositado";
            $this->sendMessage($return_text);
        }

    }

    public function EditarConta()
    {
        $inline_keyboard = new InlineKeyboard();

        $textMessage = trim($this->message->getText());
        $this->notes['requestData'] = null;
        $this->notes['dadosConta'] = $textMessage;
        $conta_id = $this->notes['conta_id'];
        $this->conversation->update();

        $sql = "SELECT * FROM usuarios WHERE dividas = 1 ORDER by permissoes_id ASC";
        $query = $this->pdo->query($sql);
        $users = $query->fetchAll();

        foreach ($users as $usuario) {

            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xE2\x9C\x85 #" . $usuario['idUsuarios'] . " - " . $usuario['nome'], 'callback_data' => 'Finalizar_EditarConta_' . $usuario['idUsuarios']
            ]));
        }
        $text = "Selecione o usuário que recebe por esta conta";
        $this->sendMessage($text, $inline_keyboard);
    }

    public function MenuUsuario()
    {

        $id = trim($this->message->getText());
        //ID ADMIN
        $userId = 1;
        $sql = "SELECT * FROM usuarios WHERE idUsuarios = $id";
        $query = $this->pdo->query($sql);
        $usuario = $query->fetch();
        $text = "";
        if (!empty($usuario)) {
            $idUsuario = $usuario['idUsuarios'];
            $totalizador = 0;

            $sql = "SELECT * FROM dividas WHERE ((enviador_id = $idUsuario AND recebedor_id = $userId) OR (recebedor_id = $idUsuario AND enviador_id = " . $userId . ")) AND status = 1";

            $query = $this->pdo->query($sql);
            $dividasTotal = $query->fetchAll();
            foreach ($dividasTotal as $d) {
                if ($d['enviador_id'] == $userId) {
                    if ($d['tipo'] == "POSITIVO") {
                        $totalizador += $d['valor'];
                    } else if ($d['tipo'] == "NEGATIVO") {
                        $totalizador -= $d['valor'];
                    }
                } else {
                    if ($d['tipo'] == "POSITIVO") {
                        $totalizador -= $d['valor'];
                    } else if ($d['tipo'] == "NEGATIVO") {
                        $totalizador += $d['valor'];
                    }
                }
            }

            $text .= $usuario['nome'] . " - ";

            if ($totalizador > 0) {
                $totalizador = abs($totalizador);
                $text .= "\xF0\x9F\x92\xB2 \xE2\x9D\x8C Deve: <b>R$$totalizador</b>\n\n";

            } else {
                $totalizador = abs($totalizador);
                $text .= "\xF0\x9F\x92\xB2 \xE2\x9C\x85 Saldo: <b>R$$totalizador</b>\n\n";
            }

            //CARRINHOS ABERTOS

            $sql = "SELECT * FROM vendas WHERE usuarios_id = " . $usuario['idUsuarios'] . " AND faturado = 0";
            $query = $this->pdo->query($sql);
            $carrinhosAbertos = $query->fetchAll();

            foreach ($carrinhosAbertos as $carrinhoAberto) {

            }
            $inline_keyboard = new InlineKeyboard();
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "Bloquear", 'callback_data' => 'Bloquear_Usuario_' . $usuario['idUsuarios']
            ]));
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "Compra Personalizada", 'callback_data' => 'Compra_Personalizada_' . $usuario['idUsuarios']
            ]));
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "Cobrança direta", 'callback_data' => 'Cobranca_Direta_' . $usuario['idUsuarios']
            ]));
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "Mandar Mensagem", 'callback_data' => 'Cobranca_Direta_' . $usuario['idUsuarios']
            ]));
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "Confiança de Conta", 'callback_data' => 'Confanca_Conta' . $usuario['idUsuarios']
            ]));
            //$text = "Digite o ID do usuário para acessar o menu";
            $this->sendMessage($text, $inline_keyboard);

        }

    }

    public function BloquearUsuario()
    {
        $id = trim($this->message->getText());

        $dataUsuario = array(
            ':bloequeado' => '1',
            ':id' => $id,
        );
        $sql = "UPDATE usuarios set bloqueado = :bloequeado WHERE idUsuarios = :id";
        $prepSql = $this->pdo->prepare($sql);

        if ($prepSql->execute($dataUsuario)) {
            $sql = "SELECT * FROM usuarios WHERE idUsuarios = $id";
            $query = $this->pdo->query($sql);
            $user = $query->fetch();

            $text = "O usuário #" . $user['idUsuarios'] . " foi bloqueado!\nNome: " . $user['nome'] . "\nChat ID: " . $user['chat_id'];
            $this->sendMessage($text);
        }
    }

    public function MensagemAviso()
    {
        $textMessage = trim($this->message->getText());
        $text = "Mensagem que será enviada:\n\n";
        $text .= $textMessage;
        $text .= "\n\nEnvie uma imagem ou Finalize o envio!";
        $this->notes['MensagemAviso'] = $textMessage;
        $this->notes['requestData'] = "ImagemMensagemAviso";
        $this->conversation->update();
        $inline_keyboard = new InlineKeyboard();
        $inline_keyboard->addRow(new InlineKeyboardButton([
            'text' => "\xE2\x9C\x85 Finalizar Envio \xE2\x9C\x85",
            'callback_data' => "Finzalizar_EnvioAviso"
        ]));
        if (!empty($this->notes['link'])) {

            @Request::sendPhoto([
                'chat_id' => $this->user['chat_id'],
                'caption' => $text,
                'photo' => Request::encodeFile($this->notes['link']),
                'reply_markup' => $inline_keyboard,
                'resize_keyboard' => true,
                'parse_mode' => 'HTML',
            ]);
        } else {
            $this->sendMessage($text, $inline_keyboard);
        }


    }

    public function ImagemMensagemAviso()
    {
        $message_type = $this->message->getType();
        if (in_array(strtolower($this->message->getType()), ['photo'])) {

            $doc = $this->message->{'get' . ucfirst($message_type)}();

            // For photos, get the best quality!
            ($message_type === 'photo') && $doc = end($doc);
            $file = Request::getFile(['file_id' => $doc->getFileId()]);

            if ($file->isOk()) {
                Request::downloadFile($file->getResult());

                $path = $file->getResult()->file_path;
                $complete_path = __DIR__ . "/../../assets/" . $path;
                $file_name = date('Ymis') . '.jpg';
                $new_path = __DIR__ . "/../../assets/avisos/" . $file_name;

                if (rename($complete_path, $new_path)) {
                    $link = "https://receitasdarkblog.icu/market/assets/avisos/$file_name";
                    //$link = "https://receitasdarkblog.icu/market/assets/avisos/$file_name";
                    $this->notes['link'] = $link;
                    $this->conversation->update();
                    $text = "Mensagem que será enviada:\n\n";
                    $text .= $this->notes['MensagemAviso'];
                    $text .= "\n\nEnvie uma imagem ou Finalize o envio!";
                    $inline_keyboard = new InlineKeyboard();
                    $inline_keyboard->addRow(new InlineKeyboardButton([
                        'text' => "\xE2\x9C\x85 Finalizar Envio \xE2\x9C\x85",
                        'callback_data' => "Finzalizar_EnvioAviso"
                    ]));

                    $this->sendMessage($text, $inline_keyboard);
                }
            } else {

                $text = "Erro ao fazer upload do arquivo.";
                $this->sendErrorMessage($text);
            }


        } else {
            $text = "Só são aceitos arquivos de imagem.";
            $this->sendErrorMessage($text);
        }
    }

    public function solicitarValorComprovante()
    {
        $textMessage = trim($this->message->getText());

        //$this->sendMessage(json_encode($this->notes));
        if (is_numeric($textMessage)) {


            $this->notes['valorTotal'] = $textMessage;
            //$this->notes['requestData'] = "PostComprovante";
            $this->conversation->update();
            $inline_keyboard = new InlineKeyboard();
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "PIX", 'callback_data' => 'Mostra_Conta_PIX'
            ]));
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "TED", 'callback_data' => 'Mostra_Conta_TED'
            ]));
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "Depósito na boca do caixa", 'callback_data' => 'Mostra_Conta_DEP'
            ]));
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "Bitcoin", 'callback_data' => 'Mostra_Conta_BTC'
            ]));

            //$text = " Me envie a foto do comprovante. \xF0\x9F\x93\xB7";
            $text = "Escolha a forma de pagamento!\n\n\xE2\x9A\xA0 Atenção \xE2\x9A\xA0\n\n<i>\xF0\x9F\x9A\xAB Após solicitar a conta você deve efetuar o pagamento em até <b>24 HORAS (PIX, TED, Depósito)</b>, ou <b>4 HORAS (Bitcoin)</b>, caso você não envie o comprovante no prazo estipulado sua conta será <b>\xE2\x9D\x97 BLOQUEADA \xE2\x9D\x97</b> do Bot! \xF0\x9F\x9A\xAB</i>\n\nSe não concorda com este termo clique em \xF0\x9F\x94\x99 <b>Voltar ao Menu Principal</b> \xF0\x9F\x94\x99";
            $this->sendMessage($text, $inline_keyboard);

        } else {
            $return_text = "O valor deve ser um número inteiro!\n\xF0\x9F\x92\xB0 Informe o valor que foi depositado";
            $this->sendMessage($return_text);
        }
    }

    public function solicitarValorComprovanteTesteee()
    {
        $textMessage = trim($this->message->getText());

        if (is_numeric($textMessage)) {
            /*
            $this->notes['valorTotal'] = $textMessage;
            $this->notes['requestData'] = "PostComprovante";
            $this->conversation->update();
            $text = "Legal!!! Me envie a foto do comprovante. \xF0\x9F\x93\xB7";
            $this->sendMessage($text);
            */
            $this->notes['valorTotal'] = $textMessage;
            $this->notes['requestData'] = null;
            $this->conversation->update();
            $this->ConfirmarDados();
        } else {
            $return_text = "O valor deve ser um número inteiro!\n\xF0\x9F\x92\xB0 Informe o valor que foi depositado";
            $this->sendMessage($return_text);
        }

    }

    public function SelecionaIcone($tipo_id)
    {
        switch ($tipo_id) {
            case "4":
                $icone = "\xF0\x9F\x8C\x85";
                break;
            case "5":
                $icone = "\xF0\x9F\x8D\x81";
                break;
            case "6":
                $icone = "\xF0\x9F\x92\x8A";
                break;
            case "7":
                $icone = "\xF0\x9F\x92\x8E";
                break;
            case "8":
                $icone = "\xF0\x9F\x94\x86";
                break;
            case "9":
                $icone = "\xF0\x9F\x8D\x84";
                break;
            case "10":
                $icone = "\xF0\x9F\x90\x8E";
                break;
            case "11":
                $icone = "\xF0\x9F\x8D\xAB";
                break;
            case "12":
                $icone = "\xF0\x9F\x92\xA8";
                break;
            case "13":
                $icone = "\xF0\x9F\x8D\xAF";
                break;
            case "14":
                $icone = "\xF0\x9F\x91\x80";
                break;
            case "15":
                $icone = "\xF0\x9F\x8C\xB3";
                break;
            case "17":
                $icone = "\xF0\x9F\x8C\x8C";
                break;
            case "18":
                $icone = "\xF0\x9F\x8E\x86";
                break;

        }
        return $icone;
    }

    public function informarDadosEnvio()
    {

        $vendaId = $this->notes['vendaId'];
        $textMessage = trim($this->message->getText());
        if (preg_match('/[0-9]{5,5}-[0-9]{3}?/', $textMessage, $matches)) {

            //if (preg_match('/[0-9]{5,5}([- ]?[0-9]{3,3})?/', $textMessage, $matches)) {
            $cep = $matches[0];
            $dataVenda = array(
                ':dadosEnvio' => $textMessage,
                ':cep' => $cep,
                ':vendaId' => $vendaId,
            );
            $sql = "UPDATE vendas set cep = :cep, dadosEnvio = :dadosEnvio WHERE idVendas = :vendaId";

            $prepSql = $this->pdo->prepare($sql);
            if ($prepSql->execute($dataVenda)) {


                $this->notes['dadosEnvio'] = $textMessage;
                $this->notes['requestData'] = null;

                $sql = "SELECT * FROM categorias WHERE status = 1";
                $query = $this->pdo->query($sql);
                $categorias = $query->fetchAll();
                $rows = $query->rowCount();

                if ($rows > 0) {
                    $inlineItens = array();
                    $i = 0;

                    $inline_keyboard = new InlineKeyboard();

                    foreach ($categorias as $categoria) {
                        $inline_keyboard->addRow(new InlineKeyboardButton([
                            'text' => $categoria['categoria'],
                            'callback_data' => "Post_Categoria_" . $categoria['idCategorias']
                        ]));
                    }
                    $this->notes['msgDadosEnvioId'] = $this->message_id;
                    $this->notes['vendaId'] = $vendaId;
                    $this->conversation->update();
                    //SOLICITA A CATEGORIA
                    $text = "#" . $vendaId . "\nConsegui armazenar os dados de envio.\nO Cep do pedido é $cep\nDe qual estoque são os produtos deste pedido?";
                    $this->sendMessage($text, $inline_keyboard);


                }
            }


        } else {

            $text = "\xE2\x9A\xA0 Ops, não consegui encontrar o seu CEP nos dados que você acabou de me enviar!.\n\nSó aceitamos CEP no seguinte formato:\n00000-000\nConfira os dados e clique em inserir dados novamente \n\nOu clique em voltar ao menu principal.";
            return $this->sendMessage($text);
        }

    }

    public function editarDadosEnvio()
    {

        $vendaId = $this->notes['vendaId'];
        $textMessage = trim($this->message->getText());
        if (preg_match('/[0-9]{5,5}-[0-9]{3}?/', $textMessage, $matches)) {

            //if (preg_match('/[0-9]{5,5}([- ]?[0-9]{3,3})?/', $textMessage, $matches)) {
            $cep = $matches[0];
            $dataVenda = array(
                ':dadosEditar' => $textMessage,
                ':vendaId' => $vendaId,
            );
            $sql = "UPDATE vendas set dadosEditar = :dadosEditar WHERE idVendas = :vendaId";

            $prepSql = $this->pdo->prepare($sql);
            if ($prepSql->execute($dataVenda)) {

                $this->notes['requestData'] = null;
                $this->notes['vendaId'] = null;
                $this->conversation->update();

                $text = "\xE2\x9C\x85 Consegui armazenar os dados de envio. Novo dados de envio:\n\n$textMessage\n\nAguarde aprovação do administrador\n";
                $this->sendMessage($text);
                //-----

                $text = "SOLICITAÇÃO DE ALTERAR PEDIDO #$vendaId\n";
                $text .= "$textMessage\n";
                $sql = "SELECT * FROM produtos INNER JOIN itens_de_vendas idv on produtos.idProdutos = idv.produtos_id WHERE idv.vendas_id = $vendaId";
                $query = $this->pdo->query($sql);
                $produtos = $query->fetchAll();
                $rows = $query->rowCount();
                $total = 0;

                $listProd = "";
                if ($rows > 0) {
                    foreach ($produtos as $produto) {
                        $produto['subTotal'] = $produto['subTotal'];
                        $listProd .= $produto['quantidade'] . " - " . $produto['descricao'] . " : R$" . $produto['subTotal'] . "\n";
                        $total += $produto['subTotal'];
                    }
                }

                $text .= "\n" . $listProd;

                $inline_keyboard_warnyj = new InlineKeyboard(
                    [['text' => "\xE2\x9C\x85 Aprovar edição", 'callback_data' => "Aprovar_Edicao_$vendaId"]],
                    [['text' => "\xE2\x9D\x8C Reprovar edição", 'callback_data' => "Reprovar_Edicao_$vendaId"]]
                );
                $this->sendMessageById(889423113, $text, $inline_keyboard_warnyj);


            }


        } else {
            $inline_keyboard = new InlineKeyboard();
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xE2\x9C\x8F Inserir dados novamente: #" . $vendaId,
                'callback_data' => "Solicitar_EditarPedido_" . $vendaId
            ]));

            $text = "\xE2\x9A\xA0 Ops, não consegui encontrar o seu CEP nos dados que você acabou de me enviar!.\n\nSó aceitamos CEP no seguinte formato:\n00000-000\nConfira os dados e me envie novamente!\n\nOu clique em voltar ao menu principal.";
            return $this->sendMessage($text, $inline_keyboard);
        }

    }

    public function sendMessage($text, InlineKeyboard $inline_keyboard = null)
    {
        //$text .= "\nUltimo ID: ".$this->notes['lastMsgId'];
        if (empty($inline_keyboard)) {
            $inline_keyboard = new InlineKeyboard(
                [['text' => "\xF0\x9F\x94\x99 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu']]
            );
        } else {
            $inline_keyboard->addRow(new InlineKeyboardButton([
                'text' => "\xF0\x9F\x94\x99 Voltar ao menu principal / Atualizar \xF0\x9F\x94\x99", 'callback_data' => 'Main_Menu'
            ]));
        }


        $data = [
            'chat_id' => $this->chat_id,
            'text' => $text,
            'reply_markup' => $inline_keyboard,
            'resize_keyboard' => true,
            'parse_mode' => 'HTML'
        ];
        $result = Request::sendMessage($data);
        $this->notes['lastMsgId'] = $result->getResult()->getMessageId();
        $this->conversation->update();
        return $this->notes['lastMsgId'];
    }

    public function sendMessageById($chat_id, $text, InlineKeyboard $inline_keyboard)
    {
        //$text .= "\nUltimo ID: ".$this->notes['lastMsgId'];
        if (!empty($inline_keyboard)) {

            $data = [
                'chat_id' => $chat_id,
                'text' => $text,
                'reply_markup' => $inline_keyboard,
                'resize_keyboard' => true,
            ];
        } else {
            $data = [
                'chat_id' => $chat_id,
                'text' => $text,
            ];
        }

        $result = Request::sendMessage($data);
        $this->notes['lastMsgId'] = $result->getResult()->getMessageId();
        $this->conversation->update();
        return $this->notes['lastMsgId'];
    }


    public function deleteMessage($message_id)
    {

        Request::deleteMessage([
            'chat_id' => $this->chat_id,
            'message_id' => $message_id,
        ]);

    }

    public function sendErrorMessage($text = "")
    {
        $return_text = $text . "Ops, ocorreu um erro aqui: \xF0\x9F\x98\xAA \nLimpe esse chat, caso o erro persista contate um administrador";
        if (!empty($text)) {
            $return_text .= "\nErro: " . $text;
        }
        return $this->sendMessage($return_text);

    }
}

?>