<div class="page-content">
    <div class="container-fluid">
        <!-- start page title -->
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0">Relatórios do Sistema</h4>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Relatório de Vendas -->
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Relatório de Vendas</h4>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo base_url()?>index.php/relatorios/vendas" method="get" target="_blank">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Data Inicial</label>
                                    <input type="date" name="dataInicial" class="form-control"/>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Data Final</label>
                                    <input type="date" name="dataFinal" class="form-control"/>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Status</label>
                                    <select name="status" class="form-control">
                                        <option value="">Todos</option>
                                        <option value="1">Aguardando</option>
                                        <option value="2">Aprovado</option>
                                        <option value="3">Finalizado</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Permissão do Vendedor</label>
                                    <select name="permissao" class="form-control">
                                        <option value="">Todas</option>
                                        <?php foreach($permissoes as $p): ?>
                                            <option value="<?php echo $p->idPermissao ?>"><?php echo $p->nome ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Estoque/Categoria</label>
                                    <select name="categoria" class="form-control">
                                        <option value="">Todos</option>
                                        <?php foreach($categorias as $c): ?>
                                            <option value="<?php echo $c->idCategorias ?>"><?php echo $c->categoria ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Tipo de Envio</label>
                                    <select name="tipoEnvio" class="form-control">
                                        <option value="">Todos</option>
                                        <option value="CARTA">Carta</option>
                                        <option value="SEDEX">Sedex</option>
                                        <option value="SEDEX10">Sedex 10</option>
                                        <option value="JADLOG">Jadlog</option>
                                        <option value="SEGURO">Seguro</option>
                                    </select>
                                </div>
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary w-100">
                                        <i class="fas fa-print me-2"></i>Gerar Relatório
                                    </button>
                                </div>
                            </div>
                        </form>

                        <div class="row mt-4">
                            <div class="col-md-6 mb-3">
                                <a href="<?php echo base_url()?>index.php/relatorios/vendedoresProdutos" target="_blank" class="btn btn-primary w-100">
                                    <i class="fas fa-users me-2"></i>Relatório de Vendedores e Produtos
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Relatório Financeiro -->
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Relatório Financeiro</h4>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo base_url()?>index.php/relatorios/financeiro" method="get" target="_blank">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Data Inicial</label>
                                    <input type="date" name="dataInicial" class="form-control"/>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Data Final</label>
                                    <input type="date" name="dataFinal" class="form-control"/>
                                </div>
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-success w-100">
                                        <i class="fas fa-dollar-sign me-2"></i>Gerar Relatório
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Relatório de Produtos -->
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Relatório de Produtos</h4>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-12">
                                <a href="<?php echo base_url()?>index.php/relatorios/produtos" target="_blank" 
                                   class="btn btn-info w-100">
                                    <i class="fas fa-box me-2"></i>Gerar Relatório
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Relatório de Vendedores -->
            <div class="col-lg-6">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Relatório de Vendedores</h4>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo base_url()?>index.php/relatorios/vendedores" method="get" target="_blank">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Data Inicial</label>
                                    <input type="date" name="dataInicial" class="form-control"/>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Data Final</label>
                                    <input type="date" name="dataFinal" class="form-control"/>
                                </div>
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-warning w-100">
                                        <i class="fas fa-users me-2"></i>Gerar Relatório
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<style>
.card {
    margin-bottom: 24px;
    box-shadow: 0 2px 3px rgba(0,0,0,0.03);
    transition: all .3s ease-in-out;
}

.card:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.card-header {
    background-color: #fff;
    border-bottom: 1px solid #e9ecef;
    padding: 1rem;
}

.card-title {
    margin: 0;
    color: #495057;
    font-size: 16px;
    font-weight: 600;
}

.card-body {
    padding: 1.25rem;
}

.form-label {
    font-weight: 500;
    margin-bottom: .5rem;
    color: #495057;
}

.form-control {
    border: 1px solid #ced4da;
    padding: .47rem .75rem;
    font-size: .875rem;
    border-radius: .25rem;
}

.form-control:focus {
    border-color: #2D335B;
    box-shadow: none;
}

.btn {
    padding: .47rem .75rem;
    font-size: .875rem;
    font-weight: 500;
    border-radius: .25rem;
}

.btn-primary {
    background-color: #2D335B;
    border-color: #2D335B;
}

.btn-primary:hover {
    background-color: #1e2142;
    border-color: #1e2142;
}

.me-2 {
    margin-right: .5rem;
}

.mb-3 {
    margin-bottom: 1rem;
}

.w-100 {
    width: 100%;
}

.mt-4 {
    margin-top: 1.5rem;
}
</style>

<div class="span12" style="margin-left: 0">
    <div class="widget-box">
        <div class="widget-title">
            <span class="icon">
                <i class="fas fa-shopping-cart"></i>
            </span>
            <h5>Relatórios de Vendas</h5>
        </div>
        <div class="widget-content">
            <div class="span4" style="margin-left: 0">
                <a href="<?php echo base_url()?>index.php/relatorios/vendas" class="button btn btn-default">
                    <span class="button__icon"><i class="fas fa-shopping-cart"></i></span>
                    <span class="button__text">Relatório de Vendas</span>
                </a>
            </div>
            
            <div class="span4">
                <a href="<?php echo base_url()?>index.php/relatorios/vendedoresProdutos" class="button btn btn-default">
                    <span class="button__icon"><i class="fas fa-users"></i></span>
                    <span class="button__text">Relatório de Vendedores e Produtos</span>
                </a>
            </div>
            
            <!-- ... outros botões ... -->
        </div>
    </div>
</div> 