<!DOCTYPE html>
<html>
<head>
    <title>Relatório de Vendedores e Produtos</title>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        body {
            font-family: 'Helvetica', Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background: #f8f9fa;
            color: #333;
            line-height: 1.6;
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 20px;
        }

        .header {
            background: linear-gradient(135deg, #2D335B, #4a5179);
            color: white;
            padding: 30px;
            border-radius: 15px;
            margin-bottom: 30px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            text-align: center;
        }

        .header h2 {
            margin: 0;
            font-size: 32px;
            font-weight: 600;
        }

        .total-geral {
            background: white;
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }

        .total-geral h3 {
            color: #2D335B;
            text-align: center;
            margin-bottom: 25px;
            font-size: 24px;
        }

        .total-geral-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 25px;
        }

        .stat-item {
            text-align: center;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 10px;
            transition: transform 0.2s;
        }

        .stat-item:hover {
            transform: translateY(-5px);
        }

        .stat-value {
            font-size: 28px;
            font-weight: 600;
            color: #2D335B;
            margin-bottom: 10px;
        }

        .stat-label {
            color: #6c757d;
            font-size: 16px;
        }

        .vendedor-card {
            background: white;
            border-radius: 15px;
            margin-bottom: 30px;
            overflow: hidden;
            box-shadow: 0 2px 15px rgba(0,0,0,0.08);
        }

        .vendedor-header {
            background: linear-gradient(135deg, #2D335B, #4a5179);
            color: white;
            padding: 25px;
            position: relative;
        }

        .vendedor-header h3 {
            margin: 0;
            font-size: 24px;
            margin-bottom: 10px;
        }

        .vendedor-stats {
            background: rgba(255,255,255,0.1);
            border-radius: 10px;
            padding: 20px;
            margin-top: 20px;
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
        }

        .produtos-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
            padding: 25px;
        }

        .produto-card {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 10px;
            border: 1px solid #e9ecef;
            transition: all 0.3s ease;
        }

        .produto-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }

        .produto-nome {
            font-size: 16px;
            font-weight: 600;
            color: #2D335B;
            margin-bottom: 15px;
        }

        .produto-info {
            display: flex;
            justify-content: space-between;
            align-items: center;
            color: #495057;
        }

        .produto-info span {
            font-size: 15px;
        }

        .produto-preco {
            font-weight: 600;
            color: #28a745;
        }

        .filtros {
            background: white;
            padding: 25px;
            border-radius: 15px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }

        .filtros form {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            align-items: end;
        }

        .filtro-item label {
            display: block;
            margin-bottom: 8px;
            color: #495057;
            font-weight: 500;
        }

        .filtro-item input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ced4da;
            border-radius: 8px;
            font-size: 14px;
        }

        .btn-filtrar {
            background: #2D335B;
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 8px;
            cursor: pointer;
            transition: background 0.2s;
        }

        .btn-filtrar:hover {
            background: #373d6d;
        }

        .btn-limpar {
            background: #6c757d;
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 8px;
            cursor: pointer;
            transition: background 0.2s;
        }

        .btn-limpar:hover {
            background: #5a6268;
        }

        .lucro-positivo {
            color: #28a745;
        }

        .lucro-negativo {
            color: #dc3545;
        }

        .vendedor-info {
            margin: 10px 0;
            padding: 10px 0;
            border-top: 1px solid rgba(255,255,255,0.1);
        }

        .vendedor-info p {
            display: inline-block;
            margin-right: 20px;
            margin-bottom: 8px;
        }

        .vendedor-info i {
            margin-right: 8px;
            width: 16px;
            text-align: center;
        }

        @media (max-width: 768px) {
            .container {
                padding: 10px;
            }
            
            .produtos-grid {
                grid-template-columns: 1fr;
            }
            
            .total-geral-grid {
                grid-template-columns: 1fr;
            }

            .vendedor-info p {
                display: block;
                margin-right: 0;
            }
        }

        .form-select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ced4da;
            border-radius: 8px;
            font-size: 14px;
            background-color: white;
            cursor: pointer;
        }

        .form-select:focus {
            border-color: #2D335B;
            outline: none;
        }

        .btn-info {
            background: #17a2b8;
            color: white;
            border: none;
            padding: 5px 10px;
            border-radius: 4px;
            cursor: pointer;
            transition: background 0.3s;
            margin-left: 15px;
            font-size: 14px;
        }

        .btn-info:hover {
            background: #138496;
        }

        .vendedor-titulo {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .vendedor-titulo h3 {
            display: flex;
            align-items: center;
            gap: 10px;
            margin: 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Relatório de Vendedores e Produtos</h2>
            <p>Gerado em: <?php echo date('d/m/Y H:i'); ?></p>
        </div>

        <button class="btn btn-primary" id="enviarMensagensBtn">Enviar Mensagens para Vendedores</button>
        <div id="statusEnvio" style="margin-top: 20px;"></div>

        <div class="filtros">
            <form method="get" id="filtroForm">
                <div class="filtro-item">
                    <label>Data Inicial</label>
                    <input type="date" name="dataInicial" value="<?php echo $this->input->get('dataInicial'); ?>">
                </div>
                <div class="filtro-item">
                    <label>Data Final</label>
                    <input type="date" name="dataFinal" value="<?php echo $this->input->get('dataFinal'); ?>">
                </div>
                <div class="filtro-item">
                    <label>Ordenar por</label>
                    <select name="ordenacao" class="form-select">
                        <option value="vendas" <?php echo $this->input->get('ordenacao') == 'vendas' ? 'selected' : ''; ?>>Quantidade de Vendas</option>
                        <option value="valor" <?php echo $this->input->get('ordenacao') == 'valor' ? 'selected' : ''; ?>>Valor Total</option>
                        <option value="lucro" <?php echo $this->input->get('ordenacao') == 'lucro' ? 'selected' : ''; ?>>Lucro Total</option>
                        <option value="cadastro" <?php echo $this->input->get('ordenacao') == 'cadastro' ? 'selected' : ''; ?>>Data de Cadastro</option>
                    </select>
                </div>
                <div class="filtro-buttons">
                    <button type="submit" class="btn-filtrar">
                        <i class="fas fa-search"></i> Aplicar Filtros
                    </button>
                    <button type="button" class="btn-limpar" onclick="limparFiltros()">
                        <i class="fas fa-eraser"></i> Limpar
                    </button>
                </div>
            </form>
        </div>

        <div class="total-geral">
            <h3>Resumo Geral</h3>
            <div class="total-geral-grid">
                <div class="stat-item">
                    <div class="stat-value">
                        <i class="fas fa-users"></i> <?php echo count($vendedores); ?>
                    </div>
                    <div class="stat-label">Vendedores Ativos</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value">
                        <i class="fas fa-shopping-cart"></i> <?php 
                        echo array_sum(array_column($vendedores, 'total_vendas')); 
                        ?>
                    </div>
                    <div class="stat-label">Total de Vendas</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value">
                        <i class="fas fa-dollar-sign"></i> R$ <?php 
                        echo number_format(array_sum(array_column($vendedores, 'valor_total')), 2, ',', '.'); 
                        ?>
                    </div>
                    <div class="stat-label">Valor Total</div>
                </div>
                <div class="stat-item">
                    <div class="stat-value <?php echo array_sum(array_column($vendedores, 'lucro_total')) >= 0 ? 'lucro-positivo' : 'lucro-negativo'; ?>">
                        <i class="fas fa-chart-line"></i> R$ <?php 
                        echo number_format(array_sum(array_column($vendedores, 'lucro_total')), 2, ',', '.'); 
                        ?>
                    </div>
                    <div class="stat-label">Lucro Total</div>
                </div>
            </div>
        </div>
<!-- Adicionar o modal para digitar a mensagem -->
<div class="modal fade" id="mensagemModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Enviar Mensagem para Vendedores</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label for="mensagem" class="form-label">Digite a mensagem:</label>
                    <textarea class="form-control" id="mensagem" rows="3"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="confirmarEnvio">Enviar Mensagens</button>
            </div>
        </div>
    </div>
</div>
        <div class="modal fade" id="mensagemModal" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Enviar Mensagem</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" id="chat_id">
                        <input type="hidden" id="vendedor_nome">
                        <div class="mb-3">
                            <label class="form-label">Mensagem para <span id="vendedor_label"></span></label>
                            <textarea class="form-control" id="mensagem" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="button" class="btn btn-primary" onclick="enviarMensagem()">Enviar</button>
                    </div>
                </div>
            </div>
        </div>

        <?php foreach ($vendedores as $vendedor): ?>
            <div class="vendedor-card">
                <div class="vendedor-header">
                    <div class="vendedor-titulo">
                        <h3>
                            <i class="fas fa-user"></i> 
                            <?php echo $vendedor->vendedor; ?>
                            <?php if(isset($vendedor->chat_id) && $vendedor->chat_id): ?>
                                <button type="button" 
                                        class="btn btn-info btn-sm"
                                        onclick="abrirModal('<?php echo $vendedor->chat_id; ?>', '<?php echo $vendedor->vendedor; ?>')">
                                    <i class="fas fa-paper-plane"></i> Enviar Mensagem
                                </button>
                            <?php endif; ?>
                        </h3>
                    </div>
                    <div class="vendedor-info">
                        <p><i class="fas fa-id-badge"></i> Permissão: <?php echo $vendedor->permissao_nome; ?></p>
                        <p><i class="fab fa-telegram"></i> Chat ID: <?php echo $vendedor->chat_id ? $vendedor->chat_id : 'Não cadastrado'; ?></p>
                        <p><i class="fas fa-calendar-alt"></i> Cadastrado em: <?php echo $vendedor->data_cadastro; ?></p>
                        <p><i class="fas fa-shopping-cart"></i> Primeira venda: <?php echo $vendedor->primeira_venda ? $vendedor->primeira_venda : 'N/D'; ?></p>
                        <p><i class="fas fa-shopping-cart"></i> Última venda: <?php echo $vendedor->ultima_venda ? $vendedor->ultima_venda : 'N/D'; ?></p>
                    </div>
                    
                    <div class="vendedor-stats">
                        <div class="stat-item">
                            <div class="stat-value"><?php echo $vendedor->total_vendas; ?></div>
                            <div class="stat-label">Vendas</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value">R$ <?php echo number_format($vendedor->valor_total, 2, ',', '.'); ?></div>
                            <div class="stat-label">Valor Total</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-value <?php echo $vendedor->lucro_total >= 0 ? 'lucro-positivo' : 'lucro-negativo'; ?>">
                                R$ <?php echo number_format($vendedor->lucro_total, 2, ',', '.'); ?>
                            </div>
                            <div class="stat-label">Lucro Total</div>
                        </div>
                    </div>
                </div>

                <div class="produtos-grid">
                    <?php 
                    if (!empty($vendedor->produtos_vendidos)):
                        $produtos = explode(',', $vendedor->produtos_vendidos);
                        foreach ($produtos as $produto):
                            list($nome, $quantidade, $preco) = explode('|', $produto);
                    ?>
                        <div class="produto-card">
                            <div class="produto-nome">
                                <i class="fas fa-box"></i> <?php echo $nome; ?>
                            </div>
                            <div class="produto-info">
                                <span><i class="fas fa-cubes"></i> Quantidade: <?php echo (int)$quantidade; ?></span>
                                <span class="produto-preco">R$ <?php echo number_format((float)$preco, 2, ',', '.'); ?></span>
                            </div>
                        </div>
                    <?php 
                        endforeach;
                    else:
                    ?>
                        <div class="produto-card">
                            <div class="produto-nome">Nenhum produto vendido no período</div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <script>
    function limparFiltros() {
        document.querySelectorAll('#filtroForm input[type="date"]').forEach(element => {
            element.value = '';
        });
        document.getElementById('filtroForm').submit();
    }

    document.addEventListener('DOMContentLoaded', function() {
        const urlParams = new URLSearchParams(window.location.search);
        urlParams.forEach((value, key) => {
            const element = document.querySelector(`[name="${key}"]`);
            if (element) element.value = value;
        });
    });

    function abrirModal(chat_id, vendedor) {
        document.getElementById('chat_id').value = chat_id;
        document.getElementById('vendedor_nome').value = vendedor;
        document.getElementById('vendedor_label').textContent = vendedor;
        document.getElementById('mensagem').value = '';
        new bootstrap.Modal(document.getElementById('mensagemModal')).show();
    }

    function enviarMensagem() {
        const chat_id = document.getElementById('chat_id').value;
        const vendedor = document.getElementById('vendedor_nome').value;
        const mensagem = document.getElementById('mensagem').value;

        if (!mensagem.trim()) {
            alert('Por favor, digite uma mensagem');
            return;
        }

        $.ajax({
            url: '<?php echo base_url('relatorios/enviarMensagemTelegram'); ?>',
            type: 'POST',
            data: {
                chat_id: chat_id,
                mensagem: mensagem,
                '<?php echo $this->security->get_csrf_token_name(); ?>': '<?php echo $this->security->get_csrf_hash(); ?>'
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    alert(`Mensagem enviada com sucesso para ${vendedor}`);
                    bootstrap.Modal.getInstance(document.getElementById('mensagemModal')).hide();
                } else {
                    alert('Erro ao enviar mensagem: ' + (response.error || 'Erro desconhecido'));
                }
            },
            error: function(xhr, status, error) {
                console.log('Status:', status);
                console.log('Error:', error);
                console.log('Response:', xhr.responseText);
                alert('Erro ao enviar mensagem. Verifique o console para mais detalhes.');
            }
        });
    }

    document.getElementById('enviarMensagensBtn').addEventListener('click', function() {
        new bootstrap.Modal(document.getElementById('mensagemModal')).show();
    });

    document.getElementById('confirmarEnvio').addEventListener('click', function() {
    const mensagem = document.getElementById('mensagem').value;
    if (!mensagem.trim()) {
        alert('Por favor, digite uma mensagem antes de enviar.');
        return;
    }
    
    enviarMensagensParaVendedores(mensagem);
    // Fechar o modal após confirmar o envio
    bootstrap.Modal.getInstance(document.getElementById('mensagemModal')).hide();
});

function enviarMensagensParaVendedores(mensagem) {
    const statusEnvio = document.getElementById('statusEnvio');
    statusEnvio.innerHTML = 'Iniciando envio...';
    
    // Obter todos os vendedores com status de venda finalizada
    $.ajax({
        url: '<?php echo base_url('index.php/relatorios/getVendedoresComVendasFinalizadas'); ?>',
        type: 'GET',
        dataType: 'json',
        success: function(vendedores) {
            if (vendedores.length === 0) {
                statusEnvio.innerHTML = 'Nenhum vendedor com vendas finalizadas encontrado.';
                return;
            }

            let index = 0;
            function enviarMensagem() {
                if (index < vendedores.length) {
                    const vendedor = vendedores[index];
                    
                    $.ajax({
                        url: '<?php echo base_url('index.php/relatorios/enviarMensagemTelegram'); ?>',
                        type: 'POST',
                        data: {
                            chat_id: vendedor.chat_id,
                            mensagem: mensagem,
                            '<?php echo $this->security->get_csrf_token_name(); ?>': '<?php echo $this->security->get_csrf_hash(); ?>'
                        },
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                statusEnvio.innerHTML += `<div>Mensagem enviada para ${vendedor.nome}</div>`;
                            } else {
                                statusEnvio.innerHTML += `<div>Erro ao enviar mensagem para ${vendedor.nome}: ${response.error}</div>`;
                            }
                        },
                        error: function(xhr, status, error) {
                            statusEnvio.innerHTML += `<div>Erro ao enviar mensagem para ${vendedor.nome}: ${error}</div>`;
                        },
                        complete: function() {
                            index++;
                            setTimeout(enviarMensagem, 1000); // Timeout de 1 segundo
                        }
                    });
                } else {
                    statusEnvio.innerHTML += '<div>Envio de mensagens concluído!</div>';
                }
            }

            enviarMensagem(); // Iniciar o envio
        },
        error: function(xhr, status, error) {
            statusEnvio.innerHTML = 'Erro ao buscar vendedores: ' + error;
        }
    });
}
</script>
</body>
</html> 