<!DOCTYPE html>
<html>
  <head>
    <title>Relatório de Produtos</title>
    <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <style>
        body {
            font-family: 'Helvetica', Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background: #f8f9fa;
            color: #333;
            line-height: 1.6;
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 20px;
        }

        .header {
            background: linear-gradient(135deg, #2D335B, #4a5179);
            color: white;
            padding: 30px;
            border-radius: 15px;
            margin-bottom: 30px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            text-align: center;
        }

        .header h2 {
            margin: 0;
            font-size: 32px;
            font-weight: 600;
        }

        .resumo {
            background: white;
            border-radius: 15px;
            padding: 25px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }

        .resumo-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-top: 20px;
        }

        .resumo-item {
            text-align: center;
            padding: 15px;
            background: #f8f9fa;
            border-radius: 10px;
        }

        .resumo-valor {
            font-size: 24px;
            font-weight: 600;
            color: #2D335B;
            margin: 10px 0;
        }

        .resumo-label {
            color: #6c757d;
            font-size: 14px;
        }

        .produtos-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
        }

        .produto-card {
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
            transition: transform 0.2s;
        }

        .produto-card:hover {
            transform: translateY(-5px);
        }

        .produto-nome {
            font-size: 18px;
            font-weight: 600;
            color: #2D335B;
            margin-bottom: 15px;
            border-bottom: 2px solid #eee;
            padding-bottom: 10px;
        }

        .produto-info {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10px;
            margin-bottom: 10px;
        }

        .info-item {
            font-size: 14px;
            color: #666;
        }

        .info-label {
            font-weight: 500;
            color: #2D335B;
        }

        .estoque {
            padding: 5px 10px;
            border-radius: 15px;
            font-size: 12px;
            font-weight: 500;
            text-align: center;
            margin-top: 10px;
        }

        .estoque-ok {
            background: #d4edda;
            color: #155724;
        }

        .estoque-baixo {
            background: #fff3cd;
            color: #856404;
        }

        .estoque-critico {
            background: #f8d7da;
            color: #721c24;
        }

        .categoria-tag {
            display: inline-block;
            padding: 3px 8px;
            background: #e9ecef;
            border-radius: 12px;
            font-size: 12px;
            color: #495057;
            margin-bottom: 10px;
        }

        .categoria-section {
            margin-bottom: 40px;
        }

        .categoria-header {
            background: linear-gradient(135deg, #2D335B, #4a5179);
            color: white;
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        }

        .categoria-header h3 {
            margin: 0;
            font-size: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .categoria-info {
            display: flex;
            gap: 20px;
            font-size: 14px;
        }

        .categoria-info span {
            background: rgba(255,255,255,0.1);
            padding: 5px 10px;
            border-radius: 15px;
        }

        @media (max-width: 768px) {
            .produtos-grid {
                grid-template-columns: 1fr;
            }

            .categoria-header {
                flex-direction: column;
                gap: 10px;
                text-align: center;
            }

            .categoria-info {
                flex-direction: column;
                gap: 5px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Relatório de Produtos</h2>
            <p>Gerado em: <?php echo date('d/m/Y H:i'); ?></p>
                      </div>

        <div class="resumo">
            <h3>Resumo Geral</h3>
            <div class="resumo-grid">
                <div class="resumo-item">
                    <div class="resumo-valor"><?php echo count($produtos); ?></div>
                    <div class="resumo-label">Total de Produtos</div>
                </div>
                <div class="resumo-item">
                    <div class="resumo-valor">
                        <?php 
                        $total_custo = 0;
                        foreach($produtos as $p) {
                            $total_custo += ($p->preco_custo * $p->quantidade_vendida);
                        }
                        echo 'R$ ' . number_format($total_custo, 2, ',', '.'); 
                        ?>
                    </div>
                    <div class="resumo-label">Custo Total Vendido</div>
                </div>
                <div class="resumo-item">
                    <div class="resumo-valor">
                          <?php
                        $total_vendas = 0;
                        foreach($produtos as $p) {
                            $total_vendas += ($p->preco_final * $p->quantidade_vendida);
                        }
                        echo 'R$ ' . number_format($total_vendas, 2, ',', '.'); 
                        ?>
                    </div>
                    <div class="resumo-label">Valor Total Vendido</div>
                </div>
                <div class="resumo-item">
                    <div class="resumo-valor">
                        <?php echo 'R$ ' . number_format($total_vendas - $total_custo, 2, ',', '.'); ?>
                    </div>
                    <div class="resumo-label">Lucro Total</div>
                </div>
            </div>
                  </div>

        <?php foreach ($produtosPorCategoria as $categoria => $produtosCategoria): ?>
            <div class="categoria-section">
                <div class="categoria-header">
                    <h3><i class="fas fa-tag"></i> <?php echo $categoria; ?></h3>
                    <div class="categoria-info">
                        <span><?php echo count($produtosCategoria); ?> produtos</span>
                        <span>Total Custo: R$ <?php echo number_format(array_sum(array_column($produtosCategoria, 'preco_custo')), 2, ',', '.'); ?></span>
                        <span>Total Venda: R$ <?php echo number_format(array_sum(array_column($produtosCategoria, 'preco_final')), 2, ',', '.'); ?></span>
                    </div>
              </div>

                <div class="produtos-grid">
                    <?php foreach ($produtosCategoria as $p): ?>
                        <div class="produto-card">
                            <div class="produto-nome">
                                <i class="fas fa-box"></i> <?php echo isset($p->descricao) ? $p->descricao : 'Sem descrição'; ?>
          </div>

                            <?php if(isset($p->categoria) && $p->categoria): ?>
                                <div class="categoria-tag">
                                    <i class="fas fa-tag"></i> <?php echo $p->categoria; ?>
                                </div>
                            <?php endif; ?>

                            <div class="produto-info">
                                <div class="info-item">
                                    <span class="info-label">Código:</span><br>
                                    <?php 
                                    $codigo = 'N/A';
                                    if(isset($p->codDeBarra) && !empty($p->codDeBarra)) {
                                        $codigo = $p->codDeBarra;
                                    } elseif(isset($p->codigo) && !empty($p->codigo)) {
                                        $codigo = $p->codigo;
                                    }
                                    echo $codigo;
                                    ?>
                                </div>
                                <div class="info-item">
                                    <span class="info-label">Estoque:</span><br>
                                    <?php echo isset($p->estoque) ? number_format($p->estoque, 0) : 0; ?> unidades
                                </div>
                                <div class="info-item">
                                    <span class="info-label">Total de Vendas:</span><br>
                                    <?php echo number_format($p->total_vendas, 0); ?> vendas
                                </div>
                                <div class="info-item">
                                    <span class="info-label">Qtd. Vendida:</span><br>
                                    <?php echo number_format($p->quantidade_vendida, 0); ?> unidades
                                </div>
                                <div class="info-item">
                                    <span class="info-label">Custo Total:</span><br>
                                    R$ <?php echo number_format($p->preco_custo * $p->quantidade_vendida, 2, ',', '.'); ?>
                                </div>
                                <div class="info-item">
                                    <span class="info-label">Vendas Total:</span><br>
                                    R$ <?php echo number_format($p->preco_final * $p->quantidade_vendida, 2, ',', '.'); ?>
                                </div>
                                <div class="info-item">
                                    <span class="info-label">Lucro:</span><br>
                                    R$ <?php echo number_format(($p->preco_final * $p->quantidade_vendida) - ($p->preco_custo * $p->quantidade_vendida), 2, ',', '.'); ?>
      </div>
</div>

                            <?php
                            $estoque_class = 'estoque-ok';
                            $estoque_text = 'Estoque Normal';
                            $estoque = isset($p->estoque) ? $p->estoque : 0;
                            $estoqueMinimo = isset($p->estoqueMinimo) ? $p->estoqueMinimo : 0;
                            
                            if($estoque <= 0) {
                                $estoque_class = 'estoque-critico';
                                $estoque_text = 'Sem Estoque';
                            } else if($estoque <= $estoqueMinimo) {
                                $estoque_class = 'estoque-critico';
                                $estoque_text = 'Estoque Crítico';
                            } else if($estoque <= ($estoqueMinimo * 2)) {
                                $estoque_class = 'estoque-baixo';
                                $estoque_text = 'Estoque Baixo';
                            }
                            ?>
                            
                            <div class="estoque <?php echo $estoque_class; ?>">
                                <?php echo $estoque_text; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
  </body>
</html>

