<!DOCTYPE html>
<html>
  <head>
    <title>Relatório Financeiro</title>
    <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css">
    <style>
        body {
            font-family: 'Helvetica', Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background: #f8f9fa;
            color: #333;
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
        }

        .header {
            background: linear-gradient(135deg, #2D335B, #4a5179);
            color: white;
            padding: 30px;
            border-radius: 15px;
            margin-bottom: 30px;
            text-align: center;
        }

        .filtros {
            background: white;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
        }

        .table {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
        }

        .table th {
            background: #2D335B;
            color: white;
            font-weight: 500;
        }

        .status-pendente {
            color: #dc3545;
            font-weight: 500;
        }

        .status-pago {
            color: #198754;
            font-weight: 500;
        }

        .btn-comprovante {
            padding: 5px 10px;
            border-radius: 5px;
            background: #2D335B;
            color: white;
            border: none;
            cursor: pointer;
            transition: all 0.3s;
        }

        .btn-comprovante:hover {
            background: #1e2142;
        }

        .modal-content {
            border-radius: 15px;
        }

        .modal-header {
            background: #2D335B;
            color: white;
            border-radius: 15px 15px 0 0;
        }

        .modal-body img {
            max-width: 100%;
            height: auto;
        }

        .resumo {
            background: white;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05);
        }

        .resumo-item {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #eee;
        }

        .resumo-item:last-child {
            border: none;
        }

        .valor-total {
            font-size: 1.2em;
            font-weight: bold;
            color: #2D335B;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Relatório Financeiro</h2>
            <p>Gerado em: <?php echo date('d/m/Y H:i'); ?></p>
        </div>

        <div class="filtros">
            <form method="get" id="filtroForm">
                <div class="row">
                    <div class="col-md-4">
                        <label class="form-label">Data Inicial</label>
                        <input type="date" name="dataInicial" class="form-control" value="<?php echo $this->input->get('dataInicial'); ?>">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Data Final</label>
                        <input type="date" name="dataFinal" class="form-control" value="<?php echo $this->input->get('dataFinal'); ?>">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-control">
                            <option value="">Todos</option>
                            <option value="0" <?php echo $this->input->get('status') === '0' ? 'selected' : ''; ?>>Pendente</option>
                            <option value="1" <?php echo $this->input->get('status') === '1' ? 'selected' : ''; ?>>Pago</option>
                        </select>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12">
                        <button type="submit" class="btn btn-primary">Filtrar</button>
                        <button type="button" class="btn btn-secondary" onclick="limparFiltros()">Limpar</button>
                    </div>
                </div>
            </form>
        </div>

        <div class="resumo">
            <h4>Resumo</h4>
            <div class="resumo-item">
                <span>Total Pendente:</span>
                <span class="valor-total text-danger">
                    R$ <?php echo number_format(isset($totais['pendente']) ? $totais['pendente'] : 0, 2, ',', '.'); ?>
                </span>
            </div>
            <div class="resumo-item">
                <span>Total Pago:</span>
                <span class="valor-total text-success">
                    R$ <?php echo number_format(isset($totais['pago']) ? $totais['pago'] : 0, 2, ',', '.'); ?>
                </span>
            </div>
            <div class="resumo-item">
                <span>Total Geral:</span>
                <span class="valor-total">
                    R$ <?php echo number_format(isset($totais['total']) ? $totais['total'] : 0, 2, ',', '.'); ?>
                </span>
            </div>
                      </div>

        <table class="table table-striped">
                      <thead>
                          <tr>
                    <th>Data</th>
                    <th>Enviador</th>
                    <th>Recebedor</th>
                    <th>Valor</th>
                    <th>Status</th>
                    <th>Comprovante</th>
                          </tr>
                      </thead>
                      <tbody>
                <?php if(isset($financeiro) && is_array($financeiro)): ?>
                    <?php foreach ($financeiro as $item): ?>
                    <tr>
                        <td><?php echo date('d/m/Y', strtotime($item->data)); ?></td>
                        <td><?php echo $item->enviador ?: 'N/A'; ?></td>
                        <td><?php echo $item->recebedor ?: 'N/A'; ?></td>
                        <td>R$ <?php echo number_format($item->valor ?: 0, 2, ',', '.'); ?></td>
                        <td class="<?php echo $item->status ? 'status-pago' : 'status-pendente'; ?>">
                            <?php echo $item->status ? 'Pago' : 'Pendente'; ?>
                        </td>
                        <td>
                            <?php if(isset($item->comprovante) && $item->comprovante): ?>
                            <button type="button" class="btn-comprovante" onclick="verComprovante('<?php echo base_url('assets/comprovantes/' . $item->comprovante); ?>')">
                                <i class="fas fa-file-image"></i> Ver
                            </button>
                            <?php else: ?>
                            <span class="text-muted">Não disponível</span>
                            <?php endif; ?>
                        </td>
                          </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                          <tr>
                        <td colspan="6" class="text-center">Nenhum registro encontrado</td>
                          </tr>
                <?php endif; ?>
            </tbody>
                  </table>
                  </div>
                   
    <!-- Modal para Comprovante -->
    <div class="modal fade" id="modalComprovante" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Comprovante</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <img src="" id="imagemComprovante" alt="Comprovante">
              </div>
          </div>
      </div>
</div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    function limparFiltros() {
        document.querySelectorAll('#filtroForm input[type="date"], #filtroForm select').forEach(element => {
            element.value = '';
        });
        document.getElementById('filtroForm').submit();
    }

    function verComprovante(url) {
        document.getElementById('imagemComprovante').src = url;
        new bootstrap.Modal(document.getElementById('modalComprovante')).show();
    }

    document.addEventListener('DOMContentLoaded', function() {
        const urlParams = new URLSearchParams(window.location.search);
        urlParams.forEach((value, key) => {
            const element = document.querySelector(`[name="${key}"]`);
            if (element) element.value = value;
        });
    });
    </script>
  </body>
</html>








