<head>
    <title>MAPOS</title>
    <meta charset="UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/bootstrap.min.css"/>
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/bootstrap-responsive.min.css"/>
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/fullcalendar.css"/>
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/main.css"/>
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/blue.css" class="skin-color"/>
    <script type="text/javascript" src="<?php echo base_url(); ?>assets/js/jquery-1.10.2.min.js"></script>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
</head>

<body style="background-color: transparent">

<div class="container-fluid">

    <div class="row-fluid">
        <div class="span12">

            <div class="widget-box">
                <div class="widget-title">
                    <h4 style="text-align: center">Relatório Financeiro do Cliente <?= $cliente->nomeCliente; ?></h4>
                </div>
                <div class="widget-content nopadding">

                    <?php if (!empty($lancamentos)) { ?>
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th style="font-size: 1.2em; padding: 5px;">Cliente/Fornecedor</th>
                                <th style="font-size: 1.2em; padding: 5px;">Valor</th>
                                <th style="font-size: 1.2em; padding: 5px;">Vencimento</th>
                                <th style="font-size: 1.2em; padding: 5px;">Forma de Pagamento</th>
                                <th style="font-size: 1.2em; padding: 5px;">Situação</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php
                            $totalDespesa = 0;
                            $saldo = 0;


                            foreach ($lancamentos as $l) {
                                $vencimento = date('d/m/Y', strtotime($l->data_vencimento));
                                $pagamento = date('d/m/Y', strtotime($l->data_pagamento));
                                if ($l->baixado == 1) {
                                    $situacao = 'Pago';
                                } else {
                                    $situacao = 'Pendente';
                                }
                                if ($l->tipo == 'receita') {
                                    $totalReceita += $l->valor;
                                } else {
                                    $totalDespesa += $l->valor;
                                }
                                echo '<tr>';
                                echo '<td>' . $l->cliente_fornecedor . '</td>';
                                echo '<td>' . $l->valor . '</td>';
                                echo '<td>' . $vencimento . '</td>';
                                echo '<td>' . $l->forma_pgto . '</td>';
                                echo '<td>' . $situacao . '</td>';
                                echo '</tr>';
                            }


                            ?>
                            </tbody>
                            <tfoot>
                            <tr>
                                <td colspan="2" style="text-align: right; color: green"><strong>Total receitas
                                        pendentes:</strong></td>
                                <td colspan="3" style="text-align: left; color: green">
                                    <strong>R$ <?php echo number_format($totalReceita, 2, ',', '.') ?></strong></td>
                            </tr>
                            </tfoot>
                        </table>
                    <?php }else{

                        echo '<h5 style="text-align: center">Nenhuma divida encontrada</h5>';
                    } ?>

                </div>

            </div>
            <h5 style="text-align: right">Data do Relatório: <?php echo date('d/m/Y'); ?></h5>

        </div>


    </div>
</div>


</body>
</html>








