<?php
class Relatorios_model extends CI_Model {


    /**
     * author: Ramon Silva 
     * email: silva018-mg@yahoo.com.br
     * 
     */
    
    function __construct() {
        parent::__construct();
    }

    
    function get($table,$fields,$where='',$perpage=0,$start=0,$one=false,$array='array'){
        
        $this->db->select($fields);
        $this->db->from($table);
        $this->db->limit($perpage,$start);
        if($where){
            $this->db->where($where);
        }
        
        $query = $this->db->get();
        
        $result =  !$one  ? $query->result() : $query->row();
        return $result;
    }

    
    function add($table,$data){
        $this->db->insert($table, $data);         
        if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
		
		return FALSE;       
    }
    
    function edit($table,$data,$fieldID,$ID){
        $this->db->where($fieldID,$ID);
        $this->db->update($table, $data);

        if ($this->db->affected_rows() >= 0)
		{
			return TRUE;
		}
		
		return FALSE;       
    }
    
    function delete($table,$fieldID,$ID){
        $this->db->where($fieldID,$ID);
        $this->db->delete($table);
        if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
		
		return FALSE;        
    }

    function count($table) {
        return $this->db->count_all($table);
    }
    
    public function clientesCustom($dataInicial = null,$dataFinal = null){
        
        if($dataInicial == null || $dataFinal == null){
            $dataInicial = date('Y-m-d');
            $dataFinal = date('Y-m-d');
        }
        $query = "SELECT * FROM clientes WHERE dataCadastro BETWEEN ? AND ?";
        return $this->db->query($query, array($dataInicial,$dataFinal))->result();
    }

    public function clientesRapid(){
        $this->db->order_by('nomeCliente','asc');
        return $this->db->get('clientes')->result();
    }

    public function cliente($cliente_id){

        $query = "SELECT c.* FROM clientes as c WHERE idClientes = $cliente_id";
        return $this->db->query($query)->result();

    }
    public function clienteDevedor($cliente_id){

        $query = "SELECT l.* FROM lancamentos as l WHERE baixado = 0 AND tipo = 'receita' AND clientes_id = $cliente_id ORDER BY data_vencimento ASC";
        return $this->db->query($query)->result();

    }
    public function clientesDevedores(){

        $query = "SELECT l.* FROM lancamentos as l WHERE baixado = 0 AND tipo = 'receita' ORDER BY data_vencimento ASC";
        return $this->db->query($query)->result();

    }

    public function produtosRapid() {
        $query = "SELECT 
                    p.*,
                    c.categoria,
                    (SELECT uv1.valor 
                     FROM usuario_valor uv1 
                     WHERE uv1.usuario_id = 1 
                     AND uv1.produto_id = p.idProdutos 
                     ORDER BY uv1.id DESC 
                     LIMIT 1) as preco_custo,
                    (SELECT uv2.valor 
                     FROM usuario_valor uv2 
                     WHERE uv2.usuario_id = 6 
                     AND uv2.produto_id = p.idProdutos 
                     ORDER BY uv2.id DESC 
                     LIMIT 1) as preco_final,
                    COALESCE((
                        SELECT SUM(iv.quantidade)
                        FROM itens_de_vendas iv
                        JOIN vendas v ON v.idVendas = iv.vendas_id
                        WHERE iv.produtos_id = p.idProdutos
                        AND v.status = 'Finalizado'
                        AND v.faturado = 1
                    ), 0) as quantidade_vendida,
                    COALESCE((
                        SELECT COUNT(DISTINCT v.idVendas)
                        FROM itens_de_vendas iv
                        JOIN vendas v ON v.idVendas = iv.vendas_id
                        WHERE iv.produtos_id = p.idProdutos
                        AND v.status = 'Finalizado'
                        AND v.faturado = 1
                    ), 0) as total_vendas
                  FROM produtos p
                  LEFT JOIN categorias c ON c.idCategorias = p.categoriaId
                  WHERE p.status = 1
                  ORDER BY c.categoria ASC, p.ordem ASC, p.descricao ASC";
        
        return $this->db->query($query)->result();
    }

    public function servicosRapid(){
        $this->db->order_by('nome','asc');
        return $this->db->get('servicos')->result();
    }

    public function osRapid(){
        $this->db->select('os.*,clientes.nomeCliente');
        $this->db->from('os');
        $this->db->join('clientes','clientes.idClientes = os.clientes_id');
        return $this->db->get()->result();
    }

    public function produtosRapidMin(){
        $this->db->order_by('descricao','asc');
        $this->db->where('estoque < estoqueMinimo');
        return $this->db->get('produtos')->result();
    }

    public function produtosCustom($precoInicial = null,$precoFinal = null,$estoqueInicial = null,$estoqueFinal = null){
        $wherePreco = "";
        $whereEstoque = "";
        if($precoInicial != null){
            $wherePreco = "AND precoVenda BETWEEN ".$this->db->escape($precoInicial)." AND ".$this->db->escape($precoFinal);
        }
        if($estoqueInicial != null){
            $whereEstoque = "AND estoque BETWEEN ".$this->db->escape($estoqueInicial)." AND ".$this->db->escape($estoqueFinal);
        }
        $query = "SELECT * FROM produtos WHERE estoque >= 0 $wherePreco $whereEstoque";
        return $this->db->query($query)->result();
    }

    public function servicosCustom($precoInicial = null,$precoFinal = null){
        $query = "SELECT * FROM servicos WHERE preco BETWEEN ? AND ?";
        return $this->db->query($query, array($precoInicial,$precoFinal))->result();
    }


    public function osCustom($dataInicial = null,$dataFinal = null,$cliente = null,$responsavel = null,$status = null){
        $whereData = "";
        $whereCliente = "";
        $whereResponsavel = "";
        $whereStatus = "";
        if($dataInicial != null){
            $whereData = "AND dataInicial BETWEEN ".$this->db->escape($dataInicial)." AND ".$this->db->escape($dataFinal);
        }
        if($cliente != null){
            $whereCliente = "AND clientes_id = ".$this->db->escape($cliente);
        }
        if($responsavel != null){
            $whereResponsavel = "AND usuarios_id = ".$this->db->escape($responsavel);
        }
        if($status != null){
            $whereStatus = "AND status = ".$this->db->escape($status);
        }
        $query = "SELECT os.*,clientes.nomeCliente FROM os LEFT JOIN clientes ON os.clientes_id = clientes.idClientes WHERE idOs != 0 $whereData $whereCliente $whereResponsavel $whereStatus";
        return $this->db->query($query)->result();
    }


    public function financeiroRapid($dataInicial = null, $dataFinal = null, $status = null) {
        $whereData = "";
        if($dataInicial && $dataFinal) {
            $whereData = "AND d.data BETWEEN '$dataInicial' AND '$dataFinal'";
        }
        
        $whereStatus = "";
        if($status !== null) {
            $whereStatus = "AND d.status = $status";
        }
        
        $query = "SELECT d.*, 
                     u1.nome as enviador, 
                     u2.nome as recebedor,
                     d.valor,
                     d.status,
                     d.comprovante
              FROM dividas d
              LEFT JOIN usuarios u1 ON u1.idUsuarios = d.enviador_id
              LEFT JOIN usuarios u2 ON u2.idUsuarios = d.recebedor_id
              WHERE 1=1 $whereData $whereStatus
              ORDER BY d.data DESC";
        
        $result = $this->db->query($query)->result();
        
        // Calcular totais
        $totais = [
            'pendente' => 0,
            'pago' => 0,
            'total' => 0
        ];
        
        foreach($result as $item) {
            if($item->status == 0) {
                $totais['pendente'] += $item->valor;
            } else {
                $totais['pago'] += $item->valor;
            }
            $totais['total'] += $item->valor;
        }
        
        return [
            'dados' => $result,
            'totais' => $totais
        ];
    }


    public function financeiroCustom($dataInicial, $dataFinal, $tipo = null, $situacao = null, $cliente_id = null){
        
        $whereTipo = "";
        $whereSituacao = "";

        if($dataInicial == null){
            $dataInicial = date('Y-m-01');
        }
        if($dataFinal == null){
            $dataFinal = date("Y-m-t");  
        }

        if($tipo == 'receita'){
            $whereTipo = "AND tipo = 'receita'";
        }
        if($tipo == 'despesa'){
            $whereTipo = "AND tipo = 'despesa'";
        }
        if($situacao == 'pendente'){
            $whereSituacao = "AND baixado = 0";
        }
        if($situacao == 'pago'){
            $whereSituacao = "AND baixado = 1";
        }

        $whereCliente = "";
        if(!empty($cliente_id)){
            $whereCliente = "clientes_id = $cliente_id AND";
        }
        
        
        $query = "SELECT * FROM lancamentos WHERE $whereCliente data_vencimento BETWEEN ? and ? $whereTipo $whereSituacao";
        return $this->db->query($query, array($dataInicial,$dataFinal))->result();
    }


    public function vendasRapid($dataInicial = null, $dataFinal = null, $cliente = null, $status = null, $permissao = null, $categoria = null, $tipoEnvio = null, $faturado = null) {
        
        $whereData = "";
        if($dataInicial && $dataFinal){
            $whereData = "AND v.dataVenda BETWEEN '$dataInicial' AND '$dataFinal'";
        }
        
        $whereCliente = "";
        if($cliente){
            $whereCliente = "AND v.clientes_id = $cliente";
        }

        $whereStatus = "";
        if($status){
            $whereStatus = "AND v.status = $status";
        }

        $wherePermissao = "";
        if($permissao){
            $wherePermissao = "AND u.permissoes_id = $permissao";
        }

        $whereCategoria = "";
        if($categoria){
            $whereCategoria = "AND v.categoria_id = $categoria";
        }

        $whereTipoEnvio = "";
        if($tipoEnvio){
            $whereTipoEnvio = "AND v.tipoEnvio = '$tipoEnvio'";
        }

        $whereFaturado = "";
        if($faturado !== null) {
            $whereFaturado = "AND v.faturado = $faturado";
        }
        
        $query = "SELECT v.*, 
                  c.nomeCliente as cliente,
                  u.nome as vendedor,
                  u.permissoes_id as vendedor_permissao,
                  p.nome as permissao,
                  cat.categoria as nome_categoria,
                  v.valorTotal as total,
                  DATE_FORMAT(v.dataVenda, '%d/%m/%Y') as data_venda,
                  (
                      v.valorTotal - 
                      COALESCE(
                          (SELECT SUM(iv.quantidade * uv1.valor)
                           FROM itens_de_vendas iv
                           CROSS JOIN usuario_valor uv1 
                           WHERE iv.vendas_id = v.idVendas 
                           AND uv1.usuario_id = 1), 0
                      ) -
                      COALESCE(
                          (SELECT SUM(iv.quantidade * uv2.valor)
                           FROM itens_de_vendas iv
                           CROSS JOIN usuario_valor uv2 
                           WHERE iv.vendas_id = v.idVendas 
                           AND uv2.usuario_id = u.permissoes_id), 0
                      )
                  ) as lucro
                  FROM vendas v 
                  LEFT JOIN clientes c ON c.idClientes = v.clientes_id
                  LEFT JOIN usuarios u ON u.idUsuarios = v.usuarios_id
                  LEFT JOIN permissoes p ON p.idPermissao = u.permissoes_id
                  LEFT JOIN categorias cat ON cat.idCategorias = v.categoria_id
                  WHERE 1=1 
                  $whereData 
                  $whereCliente 
                  $whereStatus
                  $wherePermissao
                  $whereCategoria
                  $whereTipoEnvio
                  $whereFaturado
                  ORDER BY v.idVendas DESC";
        
        return $this->db->query($query)->result();
    }


    public function vendasCustom($dataInicial = null,$dataFinal = null,$cliente = null,$responsavel = null){
        $whereData = "";
        $whereCliente = "";
        $whereResponsavel = "";
        $whereStatus = "";
        if($dataInicial != null){
            $whereData = "AND dataVenda BETWEEN ".$this->db->escape($dataInicial)." AND ".$this->db->escape($dataFinal);
        }
        if($cliente != null){
            $whereCliente = "AND clientes_id = ".$this->db->escape($cliente);
        }
        if($responsavel != null){
            $whereResponsavel = "AND usuarios_id = ".$this->db->escape($responsavel);
        }
       
        $query = "SELECT vendas.*,clientes.nomeCliente,usuarios.nome FROM vendas LEFT JOIN clientes ON vendas.clientes_id = clientes.idClientes LEFT JOIN usuarios ON vendas.usuarios_id = usuarios.idUsuarios WHERE idVendas != 0 $whereData $whereCliente $whereResponsavel";
        return $this->db->query($query)->result();
    }

    public function vendedoresRapid($dataInicial = null, $dataFinal = null){
        
        $whereData = "";
        if($dataInicial && $dataFinal){
            $whereData = "AND v.dataVenda BETWEEN '$dataInicial' AND '$dataFinal'";
        }
        
        $query = "SELECT u.nome as vendedor,
                        COUNT(v.idVendas) as total_vendas,
                        SUM(v.valorTotal) as valor_total
                 FROM usuarios u
                 LEFT JOIN vendas v ON v.usuarios_id = u.idUsuarios
                 WHERE u.fornecedor = 1 $whereData
                 GROUP BY u.idUsuarios
                 ORDER BY valor_total DESC";
        
        return $this->db->query($query)->result();
    }

    public function getPermissoes(){
        return $this->db->get('permissoes')->result();
    }

    public function getCategorias(){
        return $this->db->get('categorias')->result();
    }

    public function vendasPorVendedor($vendedor_id, $dataInicial = null, $dataFinal = null, $status = null, $faturado = null, $tipoEnvio = null) {
        $whereData = "";
        if($dataInicial && $dataFinal){
            $whereData = "AND v.dataVenda BETWEEN '$dataInicial' AND '$dataFinal'";
        }

        $whereStatus = "";
        if($status){
            $whereStatus = "AND v.status = $status";
        }

        $whereFaturado = "";
        if($faturado !== null) {
            $whereFaturado = "AND v.faturado = $faturado";
        }

        $whereTipoEnvio = "";
        if($tipoEnvio){
            $whereTipoEnvio = "AND v.tipoEnvio = '$tipoEnvio'";
        }
        
        $query = "SELECT v.*, 
                  c.nomeCliente as cliente,
                  u.nome as vendedor,
                  u.permissoes_id as vendedor_permissao,
                  p.nome as permissao_nome,
                  cat.categoria as nome_categoria,
                  v.valorTotal as total,
                  DATE_FORMAT(v.dataVenda, '%d/%m/%Y') as data_venda,
                  (
                      v.valorTotal - 
                      COALESCE(
                          (SELECT SUM(iv.quantidade * uv1.valor)
                           FROM itens_de_vendas iv
                           CROSS JOIN usuario_valor uv1 
                           WHERE iv.vendas_id = v.idVendas 
                           AND uv1.usuario_id = 1), 0
                      ) -
                      COALESCE(
                          (SELECT SUM(iv.quantidade * uv2.valor)
                           FROM itens_de_vendas iv
                           CROSS JOIN usuario_valor uv2 
                           WHERE iv.vendas_id = v.idVendas 
                           AND uv2.usuario_id = u.permissoes_id), 0
                      )
                  ) as lucro
                  FROM vendas v 
                  LEFT JOIN clientes c ON c.idClientes = v.clientes_id
                  LEFT JOIN usuarios u ON u.idUsuarios = v.usuarios_id
                  LEFT JOIN permissoes p ON p.idPermissao = u.permissoes_id
                  LEFT JOIN categorias cat ON cat.idCategorias = v.categoria_id
                  WHERE v.usuarios_id = ? 
                  $whereData 
                  $whereStatus
                  $whereFaturado
                  $whereTipoEnvio
                  ORDER BY v.dataVenda DESC";
        
        return $this->db->query($query, array($vendedor_id))->result();
    }

    public function getVendedoresComVendas($dataInicial = null, $dataFinal = null, $vendedor = null, $ordenacao = 'vendas') {
        $whereData = "";
        if($dataInicial && $dataFinal){
            $whereData = "AND v.dataVenda BETWEEN '$dataInicial' AND '$dataFinal'";
        }
        
        $whereVendedor = "";
        if($vendedor){
            $whereVendedor = "AND u.idUsuarios = $vendedor";
        }
        
        // Definir ordenação
        switch($ordenacao) {
            case 'cadastro':
                $orderBy = 'ORDER BY u.dataCadastro DESC';
                break;
            case 'valor':
                $orderBy = 'ORDER BY valor_total DESC';
                break;
            case 'lucro':
                $orderBy = 'ORDER BY lucro_total DESC';
                break;
            case 'vendas':
            default:
                $orderBy = 'ORDER BY total_vendas DESC';
                break;
        }
        
        $query = "SELECT 
                    u.idUsuarios,
                    u.nome as vendedor,
                    u.chat_id,
                    u.dataCadastro,
                    DATE_FORMAT(u.dataCadastro, '%d/%m/%Y') as data_cadastro,
                    u.permissoes_id,
                    p.nome as permissao_nome,
                    COUNT(DISTINCT v.idVendas) as total_vendas,
                    SUM(v.valorTotal) as valor_total,
                    MIN(DATE_FORMAT(v.dataVenda, '%d/%m/%Y')) as primeira_venda,
                    MAX(DATE_FORMAT(v.dataVenda, '%d/%m/%Y')) as ultima_venda,
                    SUM(
                        v.valorTotal - 
                        COALESCE(
                            (SELECT SUM(iv_inner.quantidade * uv1.valor)
                             FROM itens_de_vendas iv_inner
                             CROSS JOIN usuario_valor uv1 
                             WHERE iv_inner.vendas_id = v.idVendas 
                             AND uv1.usuario_id = 1), 0
                        ) -
                        COALESCE(
                            (SELECT SUM(iv_inner.quantidade * uv2.valor)
                             FROM itens_de_vendas iv_inner
                             CROSS JOIN usuario_valor uv2 
                             WHERE iv_inner.vendas_id = v.idVendas 
                             AND uv2.usuario_id = u.permissoes_id), 0
                        )
                    ) as lucro_total
                  FROM usuarios u
                  JOIN vendas v ON v.usuarios_id = u.idUsuarios
                  LEFT JOIN permissoes p ON p.idPermissao = u.permissoes_id
                  WHERE v.faturado = 1 
                  $whereData
                  $whereVendedor
                  GROUP BY u.idUsuarios, u.nome, u.chat_id, u.dataCadastro, u.permissoes_id, p.nome
                  $orderBy";
        
        $vendedores = $this->db->query($query)->result();
        
        // Depois, para cada vendedor, buscamos os produtos vendidos
        foreach($vendedores as $vendedor) {
            $produtos_query = "SELECT 
                                pr.descricao,
                                SUM(iv.quantidade) as quantidade,
                                pr.precoVenda
                              FROM vendas v
                              JOIN itens_de_vendas iv ON iv.vendas_id = v.idVendas
                              JOIN produtos pr ON pr.idProdutos = iv.produtos_id
                              WHERE v.usuarios_id = ? 
                              AND v.faturado = 1
                              $whereData
                              GROUP BY pr.idProdutos, pr.descricao, pr.precoVenda
                              ORDER BY pr.descricao";
            
            $produtos = $this->db->query($produtos_query, array($vendedor->idUsuarios))->result();
            
            // Formatamos os produtos em uma string
            $produtos_str = array();
            foreach($produtos as $p) {
                $produtos_str[] = $p->descricao . '|' . $p->quantidade . '|' . $p->precoVenda;
            }
            
            $vendedor->produtos_vendidos = implode(',', $produtos_str);
        }
        
        return $vendedores;
    }

    public function vendedoresComVendasFinalizadas() {
        $query = "SELECT u.idUsuarios, u.nome, u.chat_id
                  FROM usuarios u
                  JOIN vendas v ON v.usuarios_id = u.idUsuarios
                  WHERE v.status = 3 AND u.chat_id IS NOT NULL AND u.chat_id <> 0
                  GROUP BY u.idUsuarios";

        return $this->db->query($query)->result();
    }
}