<?php

class Usuarios extends CI_Controller {
    

    /**
     * author: Ramon Silva 
     * email: silva018-mg@yahoo.com.br
     * 
     */
    
    function __construct() {

        parent::__construct();
        if( (!session_id()) || (!$this->session->userdata('logado'))){
            redirect('mapos/login');
        }
        if(!$this->permission->checkPermission($this->session->userdata('permissao'),'cUsuario')){
          $this->session->set_flashdata('error','Você não tem permissão para configurar os usuários.');
          redirect(base_url());
        }

        $this->load->helper(array('form', 'codegen_helper'));
        $this->load->model('usuarios_model', '', TRUE);
        $this->load->model('permissoes_model', '', TRUE);
        $this->load->model('Dividas_model', '', TRUE);
        $this->load->model('Vendas_model', '', TRUE);

        $this->data['menuUsuarios'] = 'Usuários';
        $this->data['menuConfiguracoes'] = 'Configurações';
    }

    function index(){
		$this->gerenciar();
	}

    function enviarAlerta(){
        $apiToken = "5204611256:AAET3v7jKEH5Wz51n6Je8E2G7-4jd_tKbL4";
        try{
            $vendaId = $_POST['vendaId'];
            $venda = $this->Vendas_model->getById($vendaId);

            $usuario = $this->usuarios_model->getById($venda->usuarios_id);
            $data = [
                'chat_id' => $usuario->chat_id,
                'text' =>"Infelizmente tivemos um problema com o seu pedido. Favor entrar em contato com @ReiDosAditivos"
            ];
            $response = file_get_contents("https://api.telegram.org/bot$apiToken/sendMessage?" . http_build_query($data) );

            $data = [
                'chat_id' => 889423113,
                'text' =>"Infelizmente tivemos um problema com o seu pedido. Favor entrar em contato com @ReiDosAditivos"
            ];
            $response = file_get_contents("https://api.telegram.org/bot$apiToken/sendMessage?" . http_build_query($data) );
        }catch (\Exception $exception){
            $data = [
                'chat_id' => 889423113,
                'text' => json_encode($exception)
            ];
            $response = file_get_contents("https://api.telegram.org/bot$apiToken/sendMessage?" . http_build_query($data) );
        }

    }
	function listaUsuarios(){
        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vDividas')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar tipo de unidade.');
            redirect(base_url());
        }

        $this->load->library('table');
        $this->load->library('pagination');

        $idUsuario = $this->session->userdata('id');

        $permissoes = $this->permissoes_model->get('permissoes', '*', '');

        foreach ($permissoes as $permissao){
            $this->data['permissao'][$permissao->idPermissao] = $permissao;
        }

        $usuarios = $this->usuarios_model->get('usuarios', '*', "");

        foreach ($usuarios as $usuario) {
            $this->data['usuarios'][$usuario->idUsuarios] = $usuario;
        }

        $saldoTotal = 0;
        $totalizador = array();
        foreach ($usuarios as $u) {

            $totalizador[$u->idUsuarios]['saldo'] = 0;
            $totalizador[$u->idUsuarios]['nome'] = $u->nome;
            $totalizador[$u->idUsuarios]['pedidos'] = $u->nome;
            $dividasEnviadas = $this->Dividas_model->get('dividas', '*', "status = 1 AND enviador_id = $idUsuario AND recebedor_id = $u->idUsuarios");

            foreach ($dividasEnviadas as $de) {
                if ($de->tipo == 'POSITIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] += $de->valor;
                } else if ($de->tipo == 'NEGATIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] -= $de->valor;
                }
            }

            $dividasRecebidas = $this->Dividas_model->get('dividas', '*', "status = 1 AND enviador_id = $u->idUsuarios AND recebedor_id = $idUsuario");

            foreach ($dividasRecebidas as $dr) {
                if ($dr->tipo == 'POSITIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] -= $dr->valor;
                } else if ($dr->tipo == 'NEGATIVO') {
                    $totalizador[$u->idUsuarios]['saldo'] += $dr->valor;
                }
            }

            $saldoTotal += $totalizador[$u->idUsuarios]['saldo'];
            $totalizador[$u->idUsuarios]['quantidadePedidos'] = count($this->Vendas_model->get('vendas', '*', "status = 3 AND usuarios_id = $u->idUsuarios"));

        }

        $permissoes = $this->permissoes_model->get('permissoes', '*', "compra_ativa = 1");
        $permissoesArray = array();
        foreach ($permissoes as $permissao) {
            $permissoesArray[$permissao->idPermissao] = $permissao->nome;
        }
        $this->data['perfis'] = $permissoesArray;
        $this->data['perfis'] = $permissoesArray;
        $this->data['totalizador'] = $totalizador;
        $this->data['saldoTotal'] = $saldoTotal;


        $this->data['view'] = 'usuarios/lista_usuarios';
        $this->load->view('tema/topo',$this->data);
    }

	function gerenciar(){
        
        $this->load->library('pagination');
        

        $config['base_url'] = base_url().'index.php/usuarios/gerenciar/';
        $config['total_rows'] = $this->usuarios_model->count('usuarios');
        $config['per_page'] = 10;
        $config['next_link'] = 'Próxima';
        $config['prev_link'] = 'Anterior';
        $config['full_tag_open'] = '<div class="pagination alternate"><ul>';
        $config['full_tag_close'] = '</ul></div>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li><a style="color: #2D335B"><b>';
        $config['cur_tag_close'] = '</b></a></li>';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';	
        $config['first_link'] = 'Primeira';
        $config['last_link'] = 'Última';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        
        $this->pagination->initialize($config);
        //$usuarios = $this->usuarios_model->get($config['per_page'],$this->uri->segment(3));
        $usuarios = $this->usuarios_model->get(5000,$this->uri->segment(3));
        $this->data['results'] = array();
        foreach ($usuarios as $u) {
            $this->data['results'][$u->idUsuarios]['nome'] = $u->nome;
            $this->data['results'][$u->idUsuarios]['chat_id'] = $u->chat_id;
            $this->data['results'][$u->idUsuarios]['permissoes_id'] = $u->permissoes_id;
            $this->data['results'][$u->idUsuarios]['dividas'] = $u->dividas;

        }

        $this->data['view'] = 'usuarios/usuarios';
        $this->load->view('tema/topo',$this->data);
       
		
    }
	
    function adicionar(){  
          
        $this->load->library('form_validation');    
		$this->data['custom_error'] = '';
		
        if (!empty($_POST))
        {     

            $this->load->library('encryption');
            $this->encryption->initialize(array('driver' => 'openssl'));

            $data = array(
                    'nome' => set_value('nome'),
					'email' => set_value('email'),
					'senha' => $this->encryption->encrypt($this->input->post('senha')),
					'celular' => set_value('celular'),
					'situacao' => set_value('situacao'),
                    'permissoes_id' => $this->input->post('permissoes_id'),
					'dataCadastro' => date('Y-m-d')
            );
           
			if ($this->usuarios_model->add('usuarios',$data) == TRUE)
			{
                                $this->session->set_flashdata('success','Usuário cadastrado com sucesso!');
				redirect(base_url().'index.php/usuarios/adicionar/');
			}
			else
			{
				$this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro.</p></div>';

			}
		}
        
        $this->load->model('permissoes_model');
        $this->data['permissoes'] = $this->permissoes_model->getActive('permissoes','permissoes.idPermissao,permissoes.nome');   
		$this->data['view'] = 'usuarios/adicionarUsuario';
        $this->load->view('tema/topo',$this->data);
   
       
    }	
    
    function editar(){  
        
        if(!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))){
            $this->session->set_flashdata('error','Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        $this->load->library('form_validation');    
		$this->data['custom_error'] = '';
        $this->form_validation->set_rules('nome', 'Nome', 'trim|required');


        if ($this->form_validation->run() == false)
        {
             $this->data['custom_error'] = (validation_errors() ? '<div class="form_error">'.validation_errors().'</div>' : false);

        } else
        { 

            if ($this->input->post('idUsuarios') == 1 && $this->input->post('situacao') == 0)
            {
                $this->session->set_flashdata('error','O usuário super admin não pode ser desativado!');
                redirect(base_url().'index.php/usuarios/editar/'.$this->input->post('idUsuarios'));
            }

            $senha = $this->input->post('senha'); 
            if($senha != null){

                $this->load->library('encryption');
                $this->encryption->initialize(array('driver' => 'openssl'));

                $senha = $this->encryption->encrypt($senha);

                $data = array(
                        'nome' => $this->input->post('nome'),
                        'email' => $this->input->post('email'),
                        'senha' => $senha,
                        'celular' => $this->input->post('celular'),
                        'situacao' => $this->input->post('situacao'),
                        'permissoes_id' => $this->input->post('permissoes_id')
                );
            }  

            else{

                $data = array(
                        'nome' => $this->input->post('nome'),
                        'email' => $this->input->post('email'),
                        'celular' => $this->input->post('celular'),
                        'situacao' => $this->input->post('situacao'),
                        'permissoes_id' => $this->input->post('permissoes_id')
                );

            }  

           
			if ($this->usuarios_model->edit('usuarios',$data,'idUsuarios',$this->input->post('idUsuarios')) == TRUE)
			{
                $this->session->set_flashdata('success','Usuário editado com sucesso!');
				redirect(base_url().'index.php/usuarios/editar/'.$this->input->post('idUsuarios'));
			}
			else
			{
				$this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro</p></div>';

			}
		}

		$this->data['result'] = $this->usuarios_model->getById($this->uri->segment(3));
        $this->load->model('permissoes_model');
        $this->data['permissoes'] = $this->permissoes_model->getActive('permissoes','permissoes.idPermissao,permissoes.nome'); 

		$this->data['view'] = 'usuarios/editarUsuario';
        $this->load->view('tema/topo',$this->data);
			
      
    }
	
    public function excluir(){

            $ID =  $this->uri->segment(3);
            $this->usuarios_model->delete('usuarios','idUsuarios',$ID);             
            redirect(base_url().'index.php/usuarios/gerenciar/');
    }
}

