<?php


class Telegram extends CI_Controller
{

    /**
     * author: Ramon Silva
     * email: silva018-mg@yahoo.com.br
     *
     */

    function __construct()
    {
        parent::__construct();

        define('BOT_TOKEN', '846971800:AAHrfd8fslTiqOiPIjOrW7SWD9kIaLvzP8k');
        define('API_URL', 'https://api.telegram.org/bot'.BOT_TOKEN.'/');

        $this->load->helper(array('form', 'codegen_helper'));

        $this->load->model('vendas_model', '', TRUE);
        $this->load->model('usuarios_model', '', TRUE);
        $this->load->model('produtos_model', '', TRUE);

    }

    function processMessage($message) {

        // processa a mensagem recebida
        $message_id = $message['message_id'];
        $chat_id = $message['chat']['id'];

        if (isset($message['text'])) {

            $text = $message['text'];//texto recebido na mensagem
            if (strpos($text, "/start") === 0) {

                $user = $this->usuarios_model->getByTelegramChatId($chat_id);
                if(empty($user)){
                    sendMessage("sendMessage", array('chat_id' => $chat_id, "text" => 'Olá, '. $message['from']['first_name'].
                        '! Infelizmente não encontramos seu cadastro, contate um administrador',
                    ));
                }else{
                    sendMessage("sendMessage", array('chat_id' => $chat_id, "text" => 'Olá, '. $message['from']['first_name'].
                        '! Eu sou o bot de cadastro de vendas, vamos começar? Clique em Cadastrar Venda',
                        'reply_markup' => array(
                            'keyboard' => array(array('Cadastrar Venda')),
                            'one_time_keyboard' => true)
                    ));
                }

            } else if ($text === "Cadastrar Venda") {
                sendMessage("sendMessage", array('chat_id' => $chat_id, "text" => 'Foi',
                ));
            } else {
                sendMessage("sendMessage", array('chat_id' => $chat_id, "text" => 'Desculpe, mas não entendi essa mensagem. :('));
            }
        } else {
            sendMessage("sendMessage", array('chat_id' => $chat_id, "text" => 'Desculpe, mas só compreendo mensagens em texto'));
        }
    }

    function sendMessage($method, $parameters) {
        $options = array(
            'http' => array(
                'method'  => 'POST',
                'content' => json_encode($parameters),
                'header'=>  "Content-Type: application/json\r\n" .
                    "Accept: application/json\r\n"
            )
        );
        $context  = stream_context_create( $options );
        file_get_contents(API_URL.$method, false, $context );
    }


    function cadastraVenda(){

        $chat_id = 617711684;
        $user = $this->usuarios_model->getByTelegramChatId($chat_id);

        echo "<pre>";
        print_r($chat_id);
        echo "</pre>";

        echo "<pre>";
        print_r($user);
        echo "</pre>";
        exit;

        define('BOT_TOKEN', '899444088:AAHtWH92cmSTLfDuopygCmoOkh8SYL8Gt10');
        define('API_URL', 'https://api.telegram.org/bot'.BOT_TOKEN.'/');

        $this->data['result'] = $this->usuarios_model->getById($this->uri->segment(3));

        $this->data['custom_error'] = '';
        $dataVenda = date('Y/m/d');

        $vendedor_id = $this->session->userdata('id');
        $data = array(
            'dataVenda' => $dataVenda,
            'clientes_id' => 1,
            'usuarios_id' => $vendedor_id,
            'faturado' => 0,
            'desconto' => 0.00
        );

        if (is_numeric($id = $this->vendas_model->add('vendas', $data, true))) {
            $this->session->set_flashdata('success', 'Venda iniciada com sucesso, adicione os produtos.');
            redirect('vendas/editar/' . $id);
        }
    }

    function index()
    {
        $this->gerenciar();
    }

    function gerenciar()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vTipoUnidade')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar tipo de unidade.');
            redirect(base_url());
        }

        $this->load->library('table');
        $this->load->library('pagination');


        $config['base_url'] = base_url() . 'index.php/tipoUnidade/gerenciar/';

        $config['total_rows'] = $this->TipoUnidade_model->count('tipo_unidade');
        $config['per_page'] = 10;
        $config['next_link'] = 'Próxima';
        $config['prev_link'] = 'Anterior';
        $config['full_tag_open'] = '<div class="pagination alternate"><ul>';
        $config['full_tag_close'] = '</ul></div>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li><a style="color: #2D335B"><b>';
        $config['cur_tag_close'] = '</b></a></li>';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['first_link'] = 'Primeira';
        $config['last_link'] = 'Última';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';

        $this->pagination->initialize($config);

        $this->data['results'] = $this->TipoUnidade_model->get('tipo_unidade', 'idTipoUnidade,nomeTipoUnidade, siglaTipoUnidade', '', $config['per_page'], $this->uri->segment(3));

        $this->data['view'] = 'tipounidade/tipounidades';
        $this->load->view('tema/topo', $this->data);


    }

    function adicionar()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'aTipoUnidade')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para adicionar tipo.');
            redirect(base_url());
        }


        if (!empty($_POST['nome'])) {

            $data = array(
                'nomeTipoUnidade' => set_value('nome'),
                'siglaTipoUnidade' => set_value('sigla'),

            );

            if ($this->TipoUnidade_model->add('tipo_unidade', $data) == TRUE) {
                $this->session->set_flashdata('success', 'Tipo Unidade adicionado com sucesso!');
                redirect(base_url() . 'index.php/tipoUnidade/adicionar');
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>An Error Occured.</p></div>';
            }
        }

        $this->data['view'] = 'tipounidade/adicionarTipoUnidade';
        $this->load->view('tema/topo', $this->data);

    }

    function editar()
    {

        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'eTipoUnidade')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para editar tipo de unidade.');
            redirect(base_url());
        }
        if (!empty($_POST['nome'])) {
            $data = array(
                'nomeTipoUnidade' => $this->input->post('nome'),
                'siglaTipoUnidade' => set_value('sigla'),
            );

            if ($this->TipoUnidade_model->edit('tipo_unidade', $data, 'idTipoUnidade', $this->input->post('idTipoUnidade')) == TRUE) {
                $this->session->set_flashdata('success', 'Tipo de Unidade editado com sucesso!');
                redirect(base_url() . 'index.php/tipoUnidade/editar/' . $this->input->post('idTipoUnidade'));
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>An Error Occured</p></div>';
            }
        }

        $this->data['result'] = $this->TipoUnidade_model->getById($this->uri->segment(3));
        $this->data['view'] = 'tipounidade/editarTipoUnidade';
        $this->load->view('tema/topo', $this->data);

    }


    function visualizar()
    {

        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vTipoUnidade')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar tipo de unidade.');
            redirect(base_url());
        }

        $this->data['result'] = $this->TipoUnidade_model->getById($this->uri->segment(3));

        if ($this->data['result'] == null) {
            $this->session->set_flashdata('error', 'Tipo de Unidade não encontrado.');
            redirect(base_url() . 'index.php/tipoUnidade/editar/' . $this->input->post('idTipoUnidade'));
        }

        $this->data['view'] = 'tipounidade/visualizarTipoUnidade';
        $this->load->view('tema/topo', $this->data);

    }

    function excluir()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'dTipoUnidade')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para excluir tipo de unidade.');
            redirect(base_url());
        }


        $id = $this->input->post('id');


        if ($id == null) {

            $this->session->set_flashdata('error', 'Erro ao tentar excluir tipo de unidade.');
            redirect(base_url() . 'index.php/tipoUnidade/gerenciar/');
        }

        $this->db->where('idTipoUnidade', $id);
        $this->db->delete('tipo_unidade');


        $this->TipoUnidade_model->delete('tipo_unidade', 'idTipoUnidade', $id);


        $this->session->set_flashdata('success', 'Tipo de Unidade excluido com sucesso!');
        redirect(base_url() . 'index.php/tipounidade/gerenciar/');
    }
}

