<?php

class Tarefas extends CI_Controller {
    
    /**
     * author: Ramon Silva 
     * email: silva018-mg@yahoo.com.br
     * 
     */
    
    function __construct() {
        parent::__construct();
            if( (!session_id()) || (!$this->session->userdata('logado'))){
                redirect('mapos/login');
            }
            $this->load->helper(array('codegen_helper'));
            $this->load->model('tarefas_model','',TRUE);
            $this->load->model('tarefasComentarios_model', '', TRUE);
            $this->load->model('usuarios_model','',TRUE);
            $this->data['menuTarefas'] = 'tarefas';
	}	
	
	function index(){
		$this->gerenciar();
	}

	function gerenciar(){

        if(!$this->permission->checkPermission($this->session->userdata('permissao'),'vTarefa')){
           $this->session->set_flashdata('error','Você não tem permissão para visualizar tarefas.');
           redirect(base_url());
        }
        $this->load->library('table');
        $this->load->library('pagination');
        
   
        $config['base_url'] = base_url().'index.php/tarefas/gerenciar/';
        $config['total_rows'] = $this->tarefas_model->count('tarefas');
        $config['per_page'] = 10;
        $config['next_link'] = 'Próxima';
        $config['prev_link'] = 'Anterior';
        $config['full_tag_open'] = '<div class="pagination alternate"><ul>';
        $config['full_tag_close'] = '</ul></div>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li><a style="color: #2D335B"><b>';
        $config['cur_tag_close'] = '</b></a></li>';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['first_link'] = 'Primeira';
        $config['last_link'] = 'Última';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        
        $this->pagination->initialize($config); 	
        
	    $this->data['results'] = $this->tarefas_model->get('tarefas','id,titulo,descricao,usuario_id,data_hora_criacao,status','',$config['per_page'],$this->uri->segment(3));
       	
       	$this->data['view'] = 'tarefas/tarefas';
       	$this->load->view('tema/topo',$this->data);
	  
       
		
    }
	
    function adicionar() {

        if(!$this->permission->checkPermission($this->session->userdata('permissao'),'aTarefa')){
           $this->session->set_flashdata('error','Você não tem permissão para adicionar tarefas.');
           redirect(base_url());
        }

        $this->load->library('form_validation');


        $this->data['custom_error'] = '';

        if ($_POST) {


            $data = array(
                'titulo' => set_value('titulo'),
                'usuario_id' => $this->session->userdata('id'),
                'data_hora_criacao' => date('Y-m-d H:i:s'),
                'status' => 'A',

            );


            if ($this->tarefas_model->add('tarefas', $data) == TRUE) {


                $dataComentario = array(
                    'tarefa_id' => $this->db->insert_id(),
                    'usuario_from_id' => $this->session->userdata('id'),
                    'usuario_to_id' => set_value('usuario'),
                    'comentario' => set_value('descricao'),
                    'data_hora' => date('Y-m-d H:i:s')
                );


                if ($this->tarefasComentarios_model->add('tarefas_comentarios', $dataComentario) == TRUE) {
                    $this->session->set_flashdata('success', 'Tarefa adicionado com sucesso!');

                    redirect(base_url() . 'index.php/tarefas/adicionar/');
                }
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro.</p></div>';
            }
        }

        $usuarios = $this->usuarios_model->get();

        foreach ($usuarios as $usuario){

            $this->data['usuarios'][$usuario->idUsuarios] = $usuario->nome;
        }



        $this->data['view'] = 'tarefas/adicionarTarefa';
        $this->load->view('tema/topo', $this->data);

    }


    public function visualizar(){

        if(!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))){
            $this->session->set_flashdata('error','Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if(!$this->permission->checkPermission($this->session->userdata('permissao'),'vTarefa')){
           $this->session->set_flashdata('error','Você não tem permissão para visualizar tarefas.');
           redirect(base_url());
        }
        $this->load->library('form_validation');
        $this->data['custom_error'] = '';
        $this->data['tarefa'] = $this->tarefas_model->getById($this->uri->segment(3));
        $this->data['comentarios'] = $this->tarefas_model->getAllComentarios($this->uri->segment(3));
        $this->data['ultimoComentario'] = $this->tarefas_model->getDataUltimoComentario($this->uri->segment(3));

        if($_POST){




            $dataComentario = array(
                'tarefa_id' => set_value('tarefa_id'),
                'usuario_from_id' => $this->session->userdata('id'),
                'usuario_to_id' => set_value('usuario'),
                'comentario' => set_value('descricao'),
                'data_hora' => date('Y-m-d H:i:s')
            );


            if ($this->tarefasComentarios_model->add('tarefas_comentarios', $dataComentario) == TRUE) {

                if(!empty($_POST['finalizar']) && $_POST['finalizar'] == 1){

                    $data = array(
                        'status' => 'F'
                    );

                    if ($this->tarefas_model->edit('tarefas', $data, 'id', $this->uri->segment(3)) == TRUE) {

                    }
                }

                $this->session->set_flashdata('success', 'Tarefa adicionado com sucesso!');

                redirect(base_url() . 'index.php/tarefas/visualizar/'.$this->uri->segment(3));
            }
        }

        $this->data['view'] = 'tarefas/visualizar';

        $usuarioModel = new Usuarios_model();
        $usuarios = $usuarioModel->get();

        foreach ($usuarios as $usuario){

            $this->data['usuarios'][$usuario->idUsuarios] = $usuario->nome;
        }
        $this->load->view('tema/topo', $this->data);




        
    }
	
    public function excluir(){

            
            if(!$this->permission->checkPermission($this->session->userdata('permissao'),'dTarefa')){
               $this->session->set_flashdata('error','Você não tem permissão para excluir tarefas.');
               redirect(base_url());
            }

            
            $id =  $this->input->post('id');
            if ($id == null) {

                $this->session->set_flashdata('error', 'Erro ao tentar excluir tarefa.');
                redirect(base_url() . 'index.php/tarefas/gerenciar/');
            }


            $this->tarefas_model->delete('tarefas','id',$id);

            $this->session->set_flashdata('success','Tarefa excluido com sucesso!');            
            redirect(base_url().'index.php/tarefas/gerenciar/');
    }
}

