<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Relatorios extends CI_Controller{


    /**
     * author: Ramon Silva 
     * email: silva018-mg@yahoo.com.br
     * 
     */
    
    public function __construct() {
        parent::__construct();
        if((!session_id()) || (!$this->session->userdata('logado'))){
            redirect('mapos/login');
        }
        
        $this->load->model('Relatorios_model','',TRUE);
        $this->load->model('Vendas_model');
        $this->load->model('Produtos_model');
        $this->load->model('Clientes_model');
        $this->load->model('Mapos_model');
        $this->load->model('Usuarios_model');
        $this->load->model('Permissoes_model');
        $this->load->model('Categorias_model');
        $this->data['menuRelatorios'] = 'Relatórios';

    }

    public function index() {
        $this->data['permissoes'] = $this->Relatorios_model->getPermissoes();
        $this->data['categorias'] = $this->Relatorios_model->getCategorias();
        
        $this->data['view'] = 'relatorios/relatorios';
        $this->load->view('tema/topo', $this->data);
    }

    public function vendas() {
        $dataInicial = $this->input->get('dataInicial');
        $dataFinal = $this->input->get('dataFinal');
        $cliente = $this->input->get('cliente');
        $status = $this->input->get('status');
        $permissao = $this->input->get('permissao');
        $categoria = $this->input->get('categoria');
        $tipoEnvio = $this->input->get('tipoEnvio');
        $faturado = $this->input->get('faturado');
        
        $this->data['vendas'] = $this->Relatorios_model->vendasRapid(
            $dataInicial, 
            $dataFinal, 
            $cliente, 
            $status,
            $permissao,
            $categoria,
            $tipoEnvio,
            $faturado
        );
        
        $this->data['permissoes'] = $this->Relatorios_model->getPermissoes();
        $this->data['categorias'] = $this->Relatorios_model->getCategorias();
        $this->data['emitente'] = $this->Mapos_model->getEmitente();
        $this->data['title'] = 'Relatório de Vendas';
        
        $this->load->view('relatorios/imprimir/imprimirVendas', $this->data);
    }

    public function produtos() {
        $produtos = $this->Relatorios_model->produtosRapid();
        
        // Agrupar produtos por categoria
        $produtosPorCategoria = [];
        foreach ($produtos as $produto) {
            $categoria = isset($produto->categoria) ? $produto->categoria : 'Sem Categoria';
            if (!isset($produtosPorCategoria[$categoria])) {
                $produtosPorCategoria[$categoria] = [];
            }
            $produtosPorCategoria[$categoria][] = $produto;
        }
        
        // Ordenar categorias alfabeticamente
        ksort($produtosPorCategoria);
        
        // Mover "Sem Categoria" para o final, se existir
        if (isset($produtosPorCategoria['Sem Categoria'])) {
            $semCategoria = $produtosPorCategoria['Sem Categoria'];
            unset($produtosPorCategoria['Sem Categoria']);
            $produtosPorCategoria['Sem Categoria'] = $semCategoria;
        }
        
        $this->data['produtosPorCategoria'] = $produtosPorCategoria;
        $this->data['produtos'] = $produtos; // mantemos para o resumo geral
        $this->data['title'] = 'Relatório de Produtos';
        
        $this->load->view('relatorios/imprimir/imprimirProdutos', $this->data);
    }

    public function financeiro() {
        $dataInicial = $this->input->get('dataInicial');
        $dataFinal = $this->input->get('dataFinal');
        $status = $this->input->get('status');
        
        $resultado = $this->Relatorios_model->financeiroRapid($dataInicial, $dataFinal, $status);
        
        $this->data['financeiro'] = $resultado['dados'];
        $this->data['totais'] = $resultado['totais'];
        $this->data['emitente'] = $this->Mapos_model->getEmitente();
        $this->data['title'] = 'Relatório Financeiro';
        
        $this->load->view('relatorios/imprimir/imprimirFinanceiro', $this->data);
    }

    public function vendedores() {
        $dataInicial = $this->input->get('dataInicial');
        $dataFinal = $this->input->get('dataFinal');
        
        $this->data['vendedores'] = $this->Relatorios_model->vendedoresRapid($dataInicial, $dataFinal);
        $this->data['emitente'] = $this->Mapos_model->getEmitente();
        $this->data['title'] = 'Relatório de Vendedores';
        
        $this->load->view('relatorios/imprimir/imprimirVendedores', $this->data);
    }

    public function clienteCompleto(){


        $cliente = $_GET['cliente'];

        //-*-------- OS

        $dataInicial = null;
        $dataFinal = null;
        $cliente = $this->input->get('cliente');
        $responsavel = null;
        $status = null;
        $data['os'] = $this->Relatorios_model->osCustom($dataInicial,$dataFinal,$cliente,$responsavel,$status);
        $data['vendas'] = $this->Relatorios_model->vendasCustom($dataInicial,$dataFinal,$cliente,$responsavel);
        $this->load->helper('mpdf');

        $html = $this->load->view('relatorios/imprimir/imprimirClienteOsVenda', $data, true);
        pdf_create($html, 'relatorio_cliente_venda_os' . date('d/m/y'), TRUE);



    }

    public function clienteDevedor(){

        $cliente_id = $_REQUEST['cliente'];

        $data['lancamentos'] = $this->Relatorios_model->clienteDevedor($cliente_id);
        $data['cliente'] =  $this->Relatorios_model->cliente($cliente_id);
        $data['cliente'] = $data['cliente'][0];

        $this->load->helper('mpdf');
        //$this->load->view('relatorios/imprimir/imprimirClientes', $data);
        $html = $this->load->view('relatorios/imprimir/imprimirClienteDevedor', $data, true);
        pdf_create($html, 'relatorio_clientes_devedores' . date('d/m/y'), TRUE);

    }
    public function clientes(){

        $this->data['view'] = 'relatorios/rel_clientes';
       	$this->load->view('tema/topo',$this->data);
    }

    public function servicos(){

        $this->data['view'] = 'relatorios/rel_servicos';
       	$this->load->view('tema/topo',$this->data);

    }

    public function servicosCustom(){

        $precoInicial = $this->input->get('precoInicial');
        $precoFinal = $this->input->get('precoFinal');
        $data['servicos'] = $this->Relatorios_model->servicosCustom($precoInicial,$precoFinal);
        $this->load->helper('mpdf');
        //$this->load->view('relatorios/imprimir/imprimirServicos', $data);
        $html = $this->load->view('relatorios/imprimir/imprimirServicos', $data, true);
        pdf_create($html, 'relatorio_servicos' . date('d/m/y'), TRUE);
    }

    public function os(){
        $this->data['view'] = 'relatorios/rel_os';
       	$this->load->view('tema/topo',$this->data);
    }

    public function osRapid(){
        $data['os'] = $this->Relatorios_model->osRapid();

        $this->load->helper('mpdf');
        //$this->load->view('relatorios/imprimir/imprimirOs', $data);
        $html = $this->load->view('relatorios/imprimir/imprimirOs', $data, true);
        pdf_create($html, 'relatorio_os' . date('d/m/y'), TRUE);
    }

    public function osCustom(){
        $dataInicial = $this->input->get('dataInicial');
        $dataFinal = $this->input->get('dataFinal');
        $cliente = $this->input->get('cliente');
        $responsavel = $this->input->get('responsavel');
        $status = $this->input->get('status');
        $data['os'] = $this->Relatorios_model->osCustom($dataInicial,$dataFinal,$cliente,$responsavel,$status);
        $this->load->helper('mpdf');
        //$this->load->view('relatorios/imprimir/imprimirOs', $data);
        $html = $this->load->view('relatorios/imprimir/imprimirOs', $data, true);
        pdf_create($html, 'relatorio_os' . date('d/m/y'), TRUE);
    }

    public function clientesCustom(){
        $dataInicial = $this->input->get('dataInicial');
        $dataFinal = $this->input->get('dataFinal');

        $data['clientes'] = $this->Relatorios_model->clientesCustom($dataInicial,$dataFinal);

        $this->load->helper('mpdf');
        //$this->load->view('relatorios/imprimir/imprimirClientes', $data);
        $html = $this->load->view('relatorios/imprimir/imprimirClientes', $data, true);
        pdf_create($html, 'relatorio_clientes' . date('d/m/y'), TRUE);
    
    }

    public function clientesRapid(){
        $data['clientes'] = $this->Relatorios_model->clientesRapid();

        $this->load->helper('mpdf');
        //$this->load->view('relatorios/imprimir/imprimirClientes', $data);
        $html = $this->load->view('relatorios/imprimir/imprimirClientes', $data, true);
        pdf_create($html, 'relatorio_clientes' . date('d/m/y'), TRUE);
    }


    public function clientesDevedores(){
        $data['lancamentos'] = $this->Relatorios_model->clientesDevedores();


        $this->load->helper('mpdf');
        //$this->load->view('relatorios/imprimir/imprimirClientes', $data);
        $html = $this->load->view('relatorios/imprimir/imprimirClientesDevedores', $data, true);
        pdf_create($html, 'relatorio_clientes_devedores' . date('d/m/y'), TRUE);
    }


    public function produtosRapid(){
        $data['produtos'] = $this->Relatorios_model->produtosRapid();

        $this->load->helper('mpdf');
        //$this->load->view('relatorios/imprimir/imprimirProdutos', $data);
        $html = $this->load->view('relatorios/imprimir/imprimirProdutos', $data, true);
        pdf_create($html, 'relatorio_produtos' . date('d/m/y'), TRUE);
    }

    public function produtosRapidMin(){
        $data['produtos'] = $this->Relatorios_model->produtosRapidMin();

        $this->load->helper('mpdf');
        $html = $this->load->view('relatorios/imprimir/imprimirProdutos', $data, true);
        pdf_create($html, 'relatorio_produtos' . date('d/m/y'), TRUE);
        
    }

    public function produtosCustom(){
        $precoInicial = $this->input->get('precoInicial');
        $precoFinal = $this->input->get('precoFinal');
        $estoqueInicial = $this->input->get('estoqueInicial');
        $estoqueFinal = $this->input->get('estoqueFinal');

        $data['produtos'] = $this->Relatorios_model->produtosCustom($precoInicial,$precoFinal,$estoqueInicial,$estoqueFinal);

        $this->load->helper('mpdf');
        $html = $this->load->view('relatorios/imprimir/imprimirProdutos', $data, true);
        pdf_create($html, 'relatorio_produtos' . date('d/m/y'), TRUE);
    }

    public function servicosRapid(){
        $data['servicos'] = $this->Relatorios_model->servicosRapid();

        $this->load->helper('mpdf');
        //$this->load->view('relatorios/imprimir/imprimirServicos', $data);
        $html = $this->load->view('relatorios/imprimir/imprimirServicos', $data, true);
        pdf_create($html, 'relatorio_servicos' . date('d/m/y'), TRUE);
    }

    public function vendasRapid(){
        $data['vendas'] = $this->Relatorios_model->vendasRapid();

        $this->load->helper('mpdf');
        //$this->load->view('relatorios/imprimir/imprimirOs', $data);
        $html = $this->load->view('relatorios/imprimir/imprimirVendas', $data, true);
        pdf_create($html, 'relatorio_vendas' . date('d/m/y'), TRUE);
    }

    public function vendasCustom(){
        $dataInicial = $this->input->get('dataInicial');
        $dataFinal = $this->input->get('dataFinal');
        $cliente = $this->input->get('cliente');
        $responsavel = $this->input->get('responsavel');

        $data['vendas'] = $this->Relatorios_model->vendasCustom($dataInicial,$dataFinal,$cliente,$responsavel);
        $this->load->helper('mpdf');
        //$this->load->view('relatorios/imprimir/imprimirOs', $data);
        $html = $this->load->view('relatorios/imprimir/imprimirVendas', $data, true);
        pdf_create($html, 'relatorio_vendas' . date('d/m/y'), TRUE);
    }

    public function vendedor() {
        $vendedor_id = $this->input->get('vendedor');
        $dataInicial = $this->input->get('dataInicial');
        $dataFinal = $this->input->get('dataFinal');
        $status = $this->input->get('status');
        $faturado = $this->input->get('faturado');
        $tipoEnvio = $this->input->get('tipoEnvio');
        
        $this->data['vendas'] = $this->Relatorios_model->vendasPorVendedor(
            $vendedor_id,
            $dataInicial, 
            $dataFinal,
            $status,
            $faturado,
            $tipoEnvio
        );
        
        $this->data['vendedor'] = $this->Usuarios_model->getById($vendedor_id);
        $this->data['title'] = 'Relatório de Vendedor';
        
        $this->load->view('relatorios/imprimir/imprimirVendasVendedor', $this->data);
    }

    public function vendedoresProdutos() {
        $dataInicial = $this->input->get('dataInicial');
        $dataFinal = $this->input->get('dataFinal');
        $vendedor = $this->input->get('vendedor');
        $ordenacao = $this->input->get('ordenacao');
        
        $this->data['vendedores'] = $this->Relatorios_model->getVendedoresComVendas(
            $dataInicial, 
            $dataFinal, 
            $vendedor,
            $ordenacao
        );
        $this->data['title'] = 'Relatório de Vendedores e Produtos';
        
        $this->load->view('relatorios/imprimir/imprimirVendedoresProdutos', $this->data);
    }

    public function getPermissoes() {
        $this->db->order_by('nome', 'asc');
        return $this->db->get('permissoes')->result();
    }

    public function getCategorias() {
        $this->db->order_by('categoria', 'asc');
        return $this->db->get('categorias')->result();
    }

    public function enviarMensagemTelegram() {
        // Forçar tipo de conteúdo JSON
        $this->output->set_content_type('application/json');
        
        try {
            $chat_id = $this->input->post('chat_id');
            $mensagem = $this->input->post('mensagem');
            
            // Log para debug
            log_message('debug', 'Tentando enviar mensagem. Chat ID: ' . $chat_id . ' Mensagem: ' . $mensagem);
            
            if (!$chat_id || !$mensagem) {
                log_message('error', 'Parâmetros inválidos');
                $this->output->set_output(json_encode(['success' => false, 'error' => 'Parâmetros inválidos']));
                return;
            }

            $apiToken = "7138674876:AAGYPCFu19h0YPbJ-kTwv5fDHtlTsejo0VE";
            
            // Preparar dados
            $data = http_build_query([
                'chat_id' => $chat_id,
                'text' => $mensagem,
                'parse_mode' => 'HTML'
            ]);
            
            // Configurar CURL
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://api.telegram.org/bot$apiToken/sendMessage");
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            
            // Executar requisição
            $response = curl_exec($ch);
            
            // Log da resposta
            log_message('debug', 'Resposta do Telegram: ' . $response);
            
            if (curl_errno($ch)) {
                log_message('error', 'Curl error: ' . curl_error($ch));
                $this->output->set_output(json_encode([
                    'success' => false, 
                    'error' => 'Erro de conexão: ' . curl_error($ch)
                ]));
                curl_close($ch);
                return;
            }
            
            curl_close($ch);
            
            $result = json_decode($response, true);
            
            if ($result === null) {
                log_message('error', 'Erro ao decodificar JSON: ' . json_last_error_msg());
                $this->output->set_output(json_encode([
                    'success' => false, 
                    'error' => 'Erro ao processar resposta'
                ]));
                return;
            }
            
            if ($result['ok']) {
                $this->output->set_output(json_encode(['success' => true]));
            } else {
                log_message('error', 'Erro do Telegram: ' . ($result['description'] ?? 'Desconhecido'));
                $this->output->set_output(json_encode([
                    'success' => false, 
                    'error' => $result['description'] ?? 'Erro desconhecido'
                ]));
            }
            
        } catch (Exception $e) {
            log_message('error', 'Exception: ' . $e->getMessage());
            $this->output->set_output(json_encode([
                'success' => false, 
                'error' => $e->getMessage()
            ]));
        }
    }

    public function getVendedoresComVendasFinalizadas() {
        $this->load->model('Relatorios_model');
        $vendedores = $this->Relatorios_model->vendedoresComVendasFinalizadas();
        echo json_encode($vendedores);
    }
}
