<?php

class Produtos extends CI_Controller
{

    function __construct()
    {
        parent::__construct();
        if ((!session_id()) || (!$this->session->userdata('logado'))) {
            redirect('mapos/login');
        }

        $this->load->helper(array('form', 'codegen_helper'));
        $this->load->model('produtos_model', '', TRUE);
        $this->load->model('vendas_model', '', TRUE);
        $this->load->model('usuarioValor_model', '', TRUE);
        $this->load->model('Categorias_model', '', TRUE);
        $this->load->model('arquivos_model', '', TRUE);
        $this->load->model('permissoes_model', '', TRUE);


        $this->data['menuProdutos'] = 'Produtos';
    }

    function index()
    {
        $this->gerenciar();
    }

    function CabecalhoPlanilha( $numero ) {
        $string = '';
        while( $numero ) {
            $string = chr( 65 /* 97 para minusculas */ + ( --$numero % 26 ) ) . $string;
            $numero = (int) ( $numero / 26 );
        }
        return $string;
    }
   
    function gerarPlanilhaProdutos(){

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vProduto')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar produtos.');
            redirect(base_url());
        }


        $this->load->library('PHPExcel');
        $arquivo = "./assets/imagem_produto/catalogo.xls";
        echo $arquivo;
        $planilha = $this->phpexcel;
        $limiteCatalogo = 12;
        //CABEÇALHO
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(1).'1', 'NomeEstoque');
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(2).'1', 'UserTelegram');
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(3).'1', 'ParteCatalogo');
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(4).'1', 'ColorTop1');
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(5).'1', 'BackgroundVal');
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(6).'1', 'PromoteTextLine1');
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(7).'1', 'PromoteTextLine2');
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(8).'1', 'DaysToSend');
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(9).'1', 'Envio01Img');
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(10).'1', 'Envio01Preco');
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(11).'1', 'Envio02Img');
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(12).'1', 'Envio02Preco');
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(13).'1', 'Envio03Img');
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(14).'1', 'Envio03Preco');
        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(15).'1', 'TextFooterFinal');
        

        $coluna = 16;

        for ($i = 1; $i <= $limiteCatalogo; $i++) { 
            if(strlen($i) < 2){
                $numProd = '0'.$i;
            }else{
                $numProd = $i;
            }
            
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).'1', 'Prod'.$numProd.'Img'); 
            $coluna++;
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).'1', 'Prod'.$numProd.'Nome'); 
            $coluna++;
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).'1', 'Prod'.$numProd.'Desc'); 
            $coluna++;
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).'1', 'Prod'.$numProd.'Val1'); 
            $coluna++;
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).'1', 'Prod'.$numProd.'Val2'); 
            $coluna++;
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).'1', 'Prod'.$numProd.'Val3'); 
            $coluna++;
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).'1', 'Prod'.$numProd.'Val4'); 
            $coluna++;
        }

        $vendedores['Medicinas']['UserTelegram'] = "@ReiDosAditivos";
        $vendedores['Medicinas']['BackgroundVal'] = "bg_Medicinas.png";
        $vendedores['Medicinas']['PromoteTextLine1'] = "NOVO CANAL, FALAR COM: @ReiDosAditivos";
        $vendedores['Medicinas']['PromoteTextLine2'] = "NOVO CANAL, FALAR COM: @ReiDosAditivos";
        $vendedores['Medicinas']['TextFooterFinal'] = "mais imagens no canal do telegram";

        $vendedores['Jaiminho']['UserTelegram'] = "@JaiminhoCartero";
        $vendedores['Jaiminho']['BackgroundVal'] = "bg_Jaiminho.png";
        $vendedores['Jaiminho']['PromoteTextLine1'] = "NOVO CANAL, FALAR COM: @ReiDosAditivos";
        $vendedores['Jaiminho']['PromoteTextLine2'] = "NOVO CANAL, FALAR COM: @ReiDosAditivos";
        $vendedores['Jaiminho']['TextFooterFinal'] = "mais imagens no canal do telegram";

        //-----------------------------------------------------------------------
        //DADOS

        foreach ($vendedores as $key => $value) {
          
        }
        $estoques = $this->Categorias_model->get('categorias', '*', 'status = 1', 999, 0, 0, false, 'desc');
        $numeroLinha = 2;
        $numProduto = 0;
        $imgProdutos = array();
        foreach ($estoques as $key => $estoque) {

            $produtos = $this->produtos_model->get('produtos', '*', "categoriaId = ".$estoque->idCategorias. " AND status = 1", 999, 0, false,array('order'=>'ordem'));
            $ParteCatalogo = 1;
            if(count($produtos) > $limiteCatalogo){
                $TextParte = "Parte ".$ParteCatalogo;
            }else{
                $TextParte = "";
            }

            $NomeEstoque = $estoque->categoria;
            $UserTelegram = $vendedores['Medicinas']['UserTelegram'];
            $ColorTop1 = $estoque->imagemCor;
            $BackgroundVal = $vendedores['Medicinas']['BackgroundVal'];
            $PromoteTextLine1 =  $vendedores['Medicinas']['PromoteTextLine1'];
            $PromoteTextLine2 = $vendedores['Jaiminho']['PromoteTextLine2'];
            $TextFooterFinal = $vendedores['Medicinas']['TextFooterFinal'];
            $DaysToSend = $estoque->despache;

            $formaEnvios = array();
            if(!empty($estoque->sedex)){

                $formaEnvios['SEDEX'] = "R$".$estoque->sedex;
            }
            if(!empty($estoque->jadlog)){

                $formaEnvios['JADLOG'] = "R$".$estoque->jadlog;
            }
            if(!empty($estoque->carta)){
                $formaEnvios['CARTA'] = "R$".$estoque->carta;
            }

            $Envio01Img = "";
            $Envio01Preco = "";

            $Envio02Img = "";
            $Envio02Preco = "";

            $Envio03Img = "";
            $Envio03Preco = "";

            foreach ($formaEnvios as $key => $valorEnvio) {
                if(empty($Envio01Img)){
                    $Envio01Img = $key.".png";
                    $Envio01Preco =  $valorEnvio;
                }elseif(empty($Envio02Img)){
                    $Envio02Img = $key.".png";
                    $Envio02Preco =  $valorEnvio;
                }elseif(empty($Envio03Img)){
                    $Envio03Img = $key.".png";
                    $Envio03Preco =  $valorEnvio;
                }
            }
            echo $Envio01Img;

            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(1).$numeroLinha, $NomeEstoque);
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(2).$numeroLinha, $UserTelegram);
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(3).$numeroLinha, $TextParte);
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(4).$numeroLinha, $ColorTop1);
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(5).$numeroLinha, $BackgroundVal);
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(6).$numeroLinha, $PromoteTextLine1);
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(7).$numeroLinha, $PromoteTextLine2);
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(8).$numeroLinha, $DaysToSend);
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(9).$numeroLinha, $Envio01Img);
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(10).$numeroLinha, $Envio01Preco);
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(11).$numeroLinha, $Envio02Img);
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(12).$numeroLinha, $Envio02Preco);
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(13).$numeroLinha, $Envio03Img);
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(14).$numeroLinha, $Envio03Preco);
            $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(15).$numeroLinha, $TextFooterFinal);

            $coluna = 16;

                
                foreach ($produtos as $produto) {
                
                    if($numProduto == 12){
                        $ParteCatalogo++;
                        $TextParte = "Parte ".$ParteCatalogo;

                        $numProduto = 0; 
                        $numeroLinha++;
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(1).$numeroLinha, $NomeEstoque);
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(2).$numeroLinha, $UserTelegram);
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(3).$numeroLinha, $TextParte);
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(4).$numeroLinha, $ColorTop1);
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(5).$numeroLinha, $BackgroundVal);
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(6).$numeroLinha, $PromoteTextLine1);
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(7).$numeroLinha, $PromoteTextLine2);
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(8).$numeroLinha, $DaysToSend);
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(9).$numeroLinha, $Envio01Img);
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(10).$numeroLinha, $Envio01Preco);
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(11).$numeroLinha, $Envio02Img);
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(12).$numeroLinha, $Envio02Preco);
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(13).$numeroLinha, $Envio03Img);
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(14).$numeroLinha, $Envio03Preco);
                        $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha(15).$numeroLinha, $TextFooterFinal);
                        $coluna = 16;
                    }

                    $Img = $produto->nomeCatalogo.".jpg";
                    $Nome = $produto->nomeCatalogo;
                    $Desc = $produto->descricaoCatalogo;
                    $Val1 = "";
                    $Val2 = "";
                    $Val3 = "";
                    $Val4 = "";

                    $removeLinkImg = str_replace("https://market.twyiart.tech/assets/imagem_produto/", "", $produto->imagem);
                    $nomeArquivo = $_SERVER['DOCUMENT_ROOT'].'/assets/imagem_produto/'.$removeLinkImg;
                    $novoArquivo = $_SERVER['DOCUMENT_ROOT'].'/assets/imagem_produto/'.$Img;
                    $imgProdutos[] = $Img;

                    echo "Antigo: ".$nomeArquivo."<br />";
                    echo "Novo :" .$novoArquivo."<br /><br />";

                    copy($nomeArquivo, $novoArquivo);

                    $valores = $this->produtos_model->getValorProdutoPerfil($produto->idProdutos, 6);

                    $tipoUnidade = "un";
                    if($valores[0]->de == $valores[0]->ate){
                        $Val1 = $valores[0]->de.$tipoUnidade.": R$".$valores[0]->valor;
                    }else{
                        $Val1 = $valores[0]->de.$tipoUnidade." a ".$valores[0]->ate.$tipoUnidade. ": R$".$valores[0]->valor;        
                    }


                    if(count($valores) > 1){
                    if($valores[1]->de == $valores[1]->ate){
                    $Val2 = $valores[1]->de.$tipoUnidade.": R$".$valores[1]->valor;
                    }else{
                        $Val2 = $valores[1]->de.$tipoUnidade." a ".$valores[1]->ate.$tipoUnidade. ": R$".$valores[1]->valor;        
                    }

                    }
                    if(count($valores) > 2){
                        if($valores[2]->de == $valores[2]->ate){
                        $Val3 = $valores[2]->de.$tipoUnidade.": R$".$valores[2]->valor;
                        }else{
                            $Val3 = $valores[2]->de.$tipoUnidade." a ".$valores[2]->ate.$tipoUnidade. ": R$".$valores[2]->valor;
                        }

                    }
                    if(count($valores) > 3){
                        if($valores[3]->de == $valores[3]->ate){
                        $Val4 = $valores[3]->de.$tipoUnidade.": R$".$valores[3]->valor;
                        }else{
                            $Val4 = $valores[3]->de.$tipoUnidade." a ".$valores[3]->ate.$tipoUnidade. ": R$".$valores[3]->valor;
                        }

                    }

                    
                
                    $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).$numeroLinha, $Img); 
                    $coluna++;
                    $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).$numeroLinha, $Nome); 
                    $coluna++;
                    $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).$numeroLinha, $Desc); 
                    $coluna++;
                    $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).$numeroLinha, $Val1); 
                    $coluna++;
                    $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).$numeroLinha, $Val2); 
                    $coluna++;
                    $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).$numeroLinha, $Val3); 
                    $coluna++;
                    $planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).$numeroLinha, $Val4); 
                    $coluna++;

                    $numProduto++;
            }
            $numProduto = 0;
            $numeroLinha++;

            //$planilha->setActiveSheetIndex(0)->setCellValue($this->CabecalhoPlanilha($coluna).$numeroColuna, $nomeEstoque); 
            //$coluna++;
        }



        //foreach( range( 'A', 'Z' ) as $letra ) { print $letra; }
        $objGravar = PHPExcel_IOFactory::createWriter($planilha, 'Excel2007');
        $objGravar->save($arquivo);

        $imgProdutos[] = "catalogo.xls";

        $file_names = $imgProdutos;
//https://market.twyiart.tech/assets/imagem_produto/03-06-2022/d0a14cc1dda7fd4614144cefc7a0d313.jpg
//$url = base_url() . 'assets/imagem_produto/' . date('d-m-Y') . '/' . $file;
        //Archive name
        //$archive_file_name = 'https://market.twyiart.tech/assets/imagem_produto/catalogo.zip';
        $archive_file_name = $_SERVER['DOCUMENT_ROOT'].'/assets/imagem_produto/catalogo.zip';
        //$archive_file_name = 'catalogo.zip';
        //$archive_file_name = 'catalogo.zip';

        //Download Files path
        $file_path = $_SERVER['DOCUMENT_ROOT'].'/assets/imagem_produto/';


        $this->zipFilesAndDownload($file_names,$archive_file_name,$file_path);

    }

     function zipFilesAndDownload($file_names,$archive_file_name,$file_path){

            //echo $file_path;die;
        $zip = new ZipArchive();
        //create the file and throw the error if unsuccessful
        if ($zip->open($archive_file_name, ZIPARCHIVE::CREATE | ZIPARCHIVE::OVERWRITE )!==TRUE) {
            exit("cannot open <$archive_file_name>\n");
        }
        //add each files of $file_name array to archive

        foreach($file_names as $files)
        {
            $zip->addFile($file_path."/".$files, $files);
            echo $file_path.$files."<br />";

        }
        $zip->close();
 
        echo $archive_file_name;

        if(file_exists($archive_file_name)){

              echo "<br /><a href='https://market.twyiart.tech/assets/imagem_produto/catalogo.zip'>https://market.twyiart.tech/assets/imagem_produto/catalogo.zip</a>";
              /*
    // Forçamos o donwload do arquivo.
            header('Content-Type: application/zip');
            header('Content-Disposition: attachment; filename="'.$archive_file_name.'"');
            exit;
            readfile($archive_file_name);
            //removemos o arquivo zip após download
            unlink($archive_file_name);
            echo "lalala";
            */
        }
        //then send the headers to force download the zip file
  /*  header("Content-type: application/zip"); 
    header("Content-Disposition: attachment; filename=$archive_file_name");
    header("Content-length: " . filesize($archive_file_name));
    header("Pragma: no-cache"); 
    header("Expires: 0"); 
    readfile($archive_file_name);*/
        exit;
    }

    function fazerPublicacao(){
        $produto_id = $this->uri->segmenlistaProdutosRelt(3);

        $produto = $this->produtos_model->getById($produto_id);


        $estoque_id = $produto->categoriaId;
        $estoque = $this->Categorias_model->get('categorias', '*', 'status = 1 AND idCategorias = '.$estoque_id, 1, 0, 0, false, 'desc')[0];

        $texto_publicacao = $estoque->categoria."\n\n";
        $texto_publicacao .= "🇧🇷 Todos os estoque enviam para todo Brasil 🇧🇷\n\n";

        $icone = $this->SelecionaIconeTipo($produto->tipo_id);
        $texto_publicacao .= $icone." ".$produto->descricao." ".$icone."\n";
        $texto_publicacao .= $produto->observacao ? "\n".$produto->observacao."\n" : "";
        $texto_publicacao .= "-\n";
        if($produto->produto_confiavel == 1){
            $texto_publicacao .= "\xE2\x9C\x85 Descrição do produto garantida pela nossa equipe.\n";
        }else{
            $texto_publicacao .= "\xF0\x9F\x91\x80 Descrição informada pelo fornecedor.\n";
        }
        $texto_publicacao .= "-\n";
        $texto_publicacao .= "Preços e disponibilidade no catálogo completo.\n";
        $texto_publicacao .= "(Se não tiver no catálogo, não está disponível) \n";

        $texto_publicacao .= "-\n";
        $texto_publicacao .= "Para efetuar sua compra:\n";
        $texto_publicacao .= "@ReiDosAditivos";


        $apiToken = "6762546599:AAG3FrEQ5XJ2HXSoJ_4Cz043u5a3dQf2Ql4";
        $url = "https://api.telegram.org/bot" . $apiToken . "/sendMediaGroup";
        $postContent = [
            'chat_id' => '@ReiDosAditivosProdutos',
            'media' => json_encode([
                ['type' => 'photo', 'media' => $produto->imagem,   "caption" => $texto_publicacao ],
                //['type' => 'photo', 'media' => 'https://wbweb.com.br/images/blog/sua-empresa-precisa-ter-um-site.jpg' ],
            ]),

        ];



        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $postContent);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, ['Content-Type: multipart/form-data']);
        $result = curl_exec($curl);
        curl_close($curl);
        $return = json_decode($result);

        $message_id = $return->result[0]->message_id;
        $dataProd = array(
            'link' => 'https://t.me/ReiDosAditivosProdutos/'.$message_id,
        );
        if ($this->produtos_model->edit('produtos', $dataProd, 'idProdutos', $produto_id) == TRUE) {
            redirect(base_url() . 'index.php/produtos/listaProdutosRel/' . $estoque_id);
        }


    }
    function fazerPublicacaoTeste(){
        $produto_id = $this->uri->segment(3);

        $produto = $this->produtos_model->getById($produto_id);


        $estoque_id = $produto->categoriaId;
        $estoque = $this->Categorias_model->get('categorias', '*', 'status = 1 AND idCategorias = '.$estoque_id, 1, 0, 0, false, 'desc')[0];

        $texto_publicacao = $estoque->categoria."\n\n";
        $texto_publicacao .= "🇧🇷 Todos os estoque enviam para todo Brasil 🇧🇷\n\n";

        $icone = $this->SelecionaIconeTipo($produto->tipo_id);
        $texto_publicacao .= $icone." ".$produto->descricao." ".$icone."\n";
        $texto_publicacao .= $produto->observacao ? "\n".$produto->observacao."\n" : "";
        $texto_publicacao .= "-\n";
        if($produto->produto_confiavel == 1){
            $texto_publicacao .= "\xE2\x9C\x85 Descrição do produto garantida pela nossa equipe.\n";
        }else{
            $texto_publicacao .= "\xF0\x9F\x91\x80 Descrição informada pelo fornecedor.\n";
        }
        $texto_publicacao .= "-\n";
        $texto_publicacao .= "Preços e disponibilidade no catálogo completo.\n";
        $texto_publicacao .= "(Se não tiver no catálogo, não está disponível) \n";

        $texto_publicacao .= "-\n";
        $texto_publicacao .= "Para efetuar sua compra:\n";
        $texto_publicacao .= "@ReiDosAditivos";


        $apiToken = "6762546599:AAG3FrEQ5XJ2HXSoJ_4Cz043u5a3dQf2Ql4";
        $url = "https://api.telegram.org/bot" . $apiToken . "/sendMediaGroup";
        $postContent = [
            'chat_id' => '@sendsendtest',
            'media' => json_encode([
                ['type' => 'photo', 'media' => $produto->imagem,   "caption" => $texto_publicacao ],
                //['type' => 'photo', 'media' => 'https://wbweb.com.br/images/blog/sua-empresa-precisa-ter-um-site.jpg' ],
            ]),

        ];



        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $postContent);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, ['Content-Type: multipart/form-data']);
        $result = curl_exec($curl);
        curl_close($curl);
        $return = json_decode($result);
        redirect(base_url() . 'index.php/produtos/listaProdutosRel/' . $estoque_id);


    }
    function listaProdutosRel(){

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vProduto')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar produtos.');
            redirect(base_url());
        }

        $this->load->library('table');
        $this->load->library('pagination');
        $categoriaId = $this->uri->segment(3);
        if(!empty($categoriaId)){
            $where = "categoriaId = ".$categoriaId;
        }else{
            $where = "";
        }

        $produto = $this->input->get('produto');
        $produto_id = $this->input->get('idProduto');
        if (!empty($produto_id)) {
            $where = "idProdutos = $produto_id";
        }elseif(!empty($produto)){
            $where = "idProdutos = $produto";
        }
        //$where.= " AND status = 1";

        $config['base_url'] = base_url() . 'index.php/produtos/listaProdutosRel/';
        $config['total_rows'] = $this->produtos_model->count('produtos', $where);
        $config['per_page'] = 99999;

        $this->pagination->initialize($config);


        $fornecedores = $this->db->get('usuarios')->result();

        foreach ($fornecedores as $fornecedor) {
            $this->data['fornecedores'][$fornecedor->idUsuarios] = $fornecedor->nome;
        }


        $results = $this->produtos_model->get('produtos', '*', $where, $config['per_page'], 0, false,array('order'=>'ordem'));
        $this->data['produtos_aguardando'] = $this->produtos_model->get('produtos', '*', "status = 0 AND create_user_id IS NOT NULL AND is_bot = 1", $config['per_page'], 0, false,array('order'=>'ordem'));


        foreach ($results as $key => $result){


            $this->data['results'][$key]['data'] = $result;
            $this->data['results'][$key]['adm'] = $this->produtos_model->getValorProdutoPerfil($result->idProdutos, 1);
            $this->data['results'][$key]['final'] = $this->produtos_model->getValorProdutoPerfil($result->idProdutos, 6);
            $this->data['results'][$key]['telecrazy'] = $this->produtos_model->getValorProdutoPerfil($result->idProdutos, 4);
            $this->data['results'][$key]['super'] = $this->produtos_model->getValorProdutoPerfil($result->idProdutos, 3);
            $this->data['results'][$key]['oficiais'] = $this->produtos_model->getValorProdutoPerfil($result->idProdutos, 5);
            $this->data['results'][$key]['socio'] = $this->produtos_model->getValorProdutoPerfil($result->idProdutos, 2);
            $this->data['results'][$key]['enviador'] = $this->data['fornecedores'][$result->idFornecedor];
            $this->data['results'][$key]['fornecedor'] = $this->data['fornecedores'][$result->usuarioEnvio_id];

        }

        $this->data['estoques'] = $this->Categorias_model->get('categorias', '*', 'status = 1', 999, 0, 0, false, 'desc');
        $this->data['categoria'] = $this->Categorias_model->get('categorias', '*', 'status = 1 AND idCategorias = '.$this->uri->segment(3), 1, 0, 0, false, 'desc')[0];

        $this->data['view'] = 'produtos/listaProdutosRel';
        $this->load->view('tema/topo', $this->data);

    }


    public function SelecionaIconeTipo($tipo_id)
    {
        switch ($tipo_id) {
            case "4":
                $icone = "\xF0\x9F\x8C\x85";
                break;
            case "5":
                $icone = "\xF0\x9F\x8D\x81";
                break;
            case "6":
                $icone = "\xF0\x9F\x92\x8A";
                break;
            case "7":
                $icone = "\xF0\x9F\x92\x8E";
                break;
            case "8":
                $icone = "\xF0\x9F\x94\x86";
                break;
            case "9":
                $icone = "\xF0\x9F\x8D\x84";
                break;
            case "10":
                $icone = "\xF0\x9F\x90\x8E";
                break;
            case "11":
                $icone = "\xF0\x9F\x8D\xAB";
                break;
            case "12":
                $icone = "\xF0\x9F\x92\xA8";
                break;
            case "13":
                $icone = "\xF0\x9F\x8D\xAF";
                break;
            case "14":
                $icone = "\xF0\x9F\x91\x80";
                break;
            case "15":
                $icone = "\xF0\x9F\x8C\xB3";
                break;
            case "16":
                $icone = "\xE2\x98\x80";
                break;
            case "17":
                $icone = "\xF0\x9F\x8C\x8C";
                break;
            case "18":
                $icone = "\xF0\x9F\x8E\x86";
                break;
            case "19":
                $icone = "\xF0\x9F\x8F\xA5";
                break;
            case "20":
                $icone = "\xF0\x9F\x92\x8A";
                break;
            case "21":
                $icone = "\xF0\x9F\x92\x8E";
                break;
            case "22":
                $icone = "\xF0\x9F\x8C\x85";
                break;
            case "23":
                $icone = "\xF0\x9F\x92\xA7";
                break;

            case "24":
                $icone = "🧊";
                break;
            default:
                $icone = "";
                break;

        }
        return $icone;
    }
    function gerenciar()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vProduto')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar produtos.');
            redirect(base_url());
        }

        $this->load->library('table');
        $this->load->library('pagination');

        $where = "";
        $produto = $this->input->get('produto');
        $produto_id = $this->input->get('idProduto');
        if (!empty($produto_id)) {
            $where = "idProdutos = $produto_id";
        }elseif(!empty($produto)){
            $where = "idProdutos = $produto";
        }

        $config['base_url'] = base_url() . 'index.php/produtos/gerenciar/';
        $config['total_rows'] = $this->produtos_model->count('produtos', $where);
        $config['per_page'] = 50;
        $config['next_link'] = 'Próxima';
        $config['prev_link'] = 'Anterior';
        $config['full_tag_open'] = '<div class="pagination alternate"><ul>';
        $config['full_tag_close'] = '</ul></div>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li><a style="color: #2D335B"><b>';
        $config['cur_tag_close'] = '</b></a></li>';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['first_link'] = 'Primeira';
        $config['last_link'] = 'Última';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';

        $this->pagination->initialize($config);
        $fornecedores = $this->db->get('usuarios')->result();

        foreach ($fornecedores as $fornecedor) {
            $this->data['fornecedores'][$fornecedor->idUsuarios] = $fornecedor->nome;
        }

        $this->data['results'] = $this->produtos_model->get('produtos', '*', $where, $config['per_page'], 0, false,array('order'=>'ordem'));

        $this->data['estoques'] = $this->Categorias_model->get('categorias', '*', 'status = 1', $config['per_page'], $this->uri->segment(3), 0, false, 'desc');

        $this->data['view'] = 'produtos/produtos';
        $this->load->view('tema/topo', $this->data);


    }
    function catalogo()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vProduto')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar produtos.');
            redirect(base_url());
        }
        $this->load->model('Usuarios_model');
        $this->load->model('UsuarioValor_model');
        $this->load->model('permissoes_model', '', TRUE);
        $permissoes = $this->permissoes_model->get('permissoes', '*', "compra_ativa = 1");
        $permissoesArray = array();
        foreach ($permissoes as $permissao) {
            $permissoesArray[$permissao->idPermissao] = $permissao->nome;
        }
        $resultArray = array();

        $valoresProdutos = array();
        $estoques = $this->Categorias_model->get('categorias', '*', 'status = 1', 0, 0  , 0, false, 'desc');
        foreach ($estoques as $estoque){
            $resultArray[$estoque->idCategorias]['nome'] = $estoque->categoria;
            $produtos = $this->produtos_model->get('produtos', '*', 'categoriaId = '.$estoque->idCategorias.' AND status = 1', 99, 0, false,array('order'=>'status, categoriaId'));

            //$resultArray[$estoque->idCategorias]['produtos']['model'] =  $produtos;
            foreach ($produtos as $produto){
                $resultArray[$estoque->idCategorias]['produtos'][$produto->idProdutos]['model'] =  $produto;
                $permissoes = $this->permissoes_model->get('permissoes', '*', "compra_ativa = 1");
                foreach ($permissoes as $permissao) {

                    $usuarioValor = @$this->UsuarioValor_model->get('usuario_valor', '*', "usuario_id = ".$permissao->idPermissao." AND produto_id = " . $produto->idProdutos)[0];
                    if(!empty($usuarioValor)){
                        $valoresProdutos[$produto->idProdutos][$permissao->idPermissao] = $usuarioValor->valor;
                    }else{
                        $valoresProdutos[$produto->idProdutos][$permissao->idPermissao] = 0;
                    }
                }
            }




        }

        $this->data['permissoesArray'] = $permissoesArray;
            $this->data['valoresProdutos'] = $valoresProdutos;
        $this->data['resultArray'] = $resultArray;
        $this->data['view'] = 'produtos/catalogo';
        $this->load->view('tema/topo', $this->data);

    }

    function produtoEstoque()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vProduto')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar produtos.');
            redirect(base_url());
        }


        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }


        $this->load->library('table');
        $this->load->library('pagination');

        $where = "categoriaId = ".$this->uri->segment(3);
        $produto = $this->input->get('produto');
        $produto_id = $this->input->get('idProduto');



        $config['base_url'] = base_url() . 'index.php/produtos/gerenciar/';
        $config['total_rows'] = $this->produtos_model->count('produtos', $where);
        $config['per_page'] = 50;
        $config['next_link'] = 'Próxima';
        $config['prev_link'] = 'Anterior';
        $config['full_tag_open'] = '<div class="pagination alternate"><ul>';
        $config['full_tag_close'] = '</ul></div>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li><a style="color: #2D335B"><b>';
        $config['cur_tag_close'] = '</b></a></li>';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tag_close'] = '</li>';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['first_link'] = 'Primeira';
        $config['last_link'] = 'Última';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';

        $this->pagination->initialize($config);
        $fornecedores = $this->db->get('usuarios')->result();

        foreach ($fornecedores as $fornecedor) {
            $this->data['fornecedores'][$fornecedor->idUsuarios] = $fornecedor->nome;
        }


        $this->data['results'] = $this->produtos_model->get('produtos', '*', $where, $config['per_page'], 0, false,array('order'=>'ordem'));

        $this->data['estoques'] = $this->Categorias_model->get('categorias', '*', 'status = 1', 0, 0  , 0, false, 'desc');
        $this->data['categoria'] = $this->Categorias_model->getById($this->uri->segment(3));

        $this->data['view'] = 'produtos/produtos';
        $this->load->view('tema/topo', $this->data);


    }


    function adicionar()
    {
        $this->load->model('permissoes_model', '', TRUE);

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'aProduto')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para adicionar produtos.');
            redirect(base_url());
        }

        $this->load->library('form_validation');
        $this->data['custom_error'] = '';
        $this->load->model('Usuarios_model');
        $this->load->model('UsuarioValor_model');

        if ($this->form_validation->run('produtos') == false) {
            $this->data['custom_error'] = (validation_errors() ? '<div class="form_error">' . validation_errors() . '</div>' : false);
        } else {
            $validaNome = $this->produtos_model->get('produtos', 'idProdutos', "descricao LIKE '" . set_value('descricao') . "'");
            if (empty($validaNome)) {
                if (!empty(set_value('codigoInterno'))) {
                    $validaInterno = $this->produtos_model->get('produtos', 'idProdutos', "codigoInterno LIKE '" . set_value('codigoInterno') . "'");
                }
                if (empty($validaInterno)) {
                    if (!empty(set_value('codigoBarras'))) {
                        $validaBarras = $this->produtos_model->get('produtos', 'idProdutos', "codigoBarras LIKE '" . set_value('codigoBarras') . "'");
                    }

                    if (empty($validaBarras)) {
                        $precoCompra = $this->input->post('precoCompra');
                        $precoCompra = str_replace(",", "", $precoCompra);
                        $precoVenda = $this->input->post('precoVenda');
                        $precoVenda = str_replace(",", "", $precoVenda);
                        $data = array(
                            'descricao' => set_value('descricao'),
                            'sigla' => set_value('sigla'),
                            'unidade' => set_value('unidade'),
                            'precoCompra' => $precoCompra,
                            'precoVenda' => $precoVenda,
                            'estoque' => set_value('estoque'),
                            'estoqueMinimo' => set_value('estoqueMinimo'),
                            'saida' => set_value('saida'),
                            'entrada' => set_value('entrada'),
                            //'codigoInterno' => set_value('codigoInterno'),
                            //'codigoBarras' => set_value('codigoBarras'),
                            'idFornecedor' => set_value('idFornecedor'),
                            'usuarioEnvio_id' => set_value('usuarioEnvio_id'),
                            'taxaEnvio' => set_value('taxaEnvio'),
                            'categoriaId' => set_value('categoria'),
                            'status' => set_value('status'),
                        );

                        if ($this->produtos_model->add('produtos', $data) == TRUE) {
                            $idProduto = $this->db->insert_id("produtos");
                            $permissoes = $this->db->get('permissoes')->result();

                                foreach ($permissoes as $permissao){

                                    if(set_value('usuario_valor_'.$permissao->idPermissao) != 0){
                                        $usuario_valor = str_replace(",", "", $this->input->post('usuario_valor_'.$permissao->idPermissao));
                                    }else{
                                        $usuario_valor = $precoVenda;
                                    }

                                    $data = array(
                                        'usuario_id' => $permissao->idPermissao,
                                        'produto_id' => $idProduto,
                                        'valor' => $usuario_valor,
                                        'quantidade_vendido' => 0,

                                    );

                                    if ($this->usuarioValor_model->add('usuario_valor', $data) == TRUE) {

                                    }
                                }

                                $this->session->set_flashdata('success', 'Produto adicionado com sucesso!');
                                redirect(base_url() . 'index.php/produtos/adicionar/');

                            $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro.</p></div>';
                        } else {
                            $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro.</p></div>';
                        }
                    } else {
                        $this->data['custom_error'] = '<div class="form_error"><p>Já existe um produto com este código de barras cadastrado.</p></div>';
                    }
                } else {
                    $this->data['custom_error'] = '<div class="form_error"><p>Já existe um produto com este código interno cadastrado.</p></div>';
                }
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>Já existe um produto com esta descrição cadastrada.</p></div>';
            }
        }

        $caterogias = $this->db->get('categorias')->result();
        foreach ($caterogias as $categoria) {
            $this->data['categorias'][$categoria->idCategorias] = $categoria->categoria;
        }

        $fornecedores = $this->UsuarioValor_model->get('usuarios')->result();

        foreach ($fornecedores as $fornecedor) {
            $this->data['fornecedores'][$fornecedor->idUsuarios] = $fornecedor->nome;
        }

        $permissoes = $this->permissoes_model->get('permissoes', '*', "compra_ativa = 1");

        foreach ($permissoes as $permissao) {
            $this->data['permissoes'][$permissao->idPermissao] = $permissao->nome;
        }


        $this->data['usuarios'] = $this->Usuarios_model->get();

        $this->data['view'] = 'produtos/adicionarProduto';
        $this->load->view('tema/topo', $this->data);

    }

    function editar()
    {

        $this->load->model('Usuarios_model');
        $this->load->model('UsuarioValor_model');
        $this->load->model('permissoes_model', '', TRUE);

        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'eProduto')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para editar produtos.');
            redirect(base_url());
        }
        $this->load->library('form_validation');
        $this->data['custom_error'] = '';


        if($_POST){
            $validaNome = $this->produtos_model->get('produtos', 'idProdutos', "descricao LIKE '" . $this->input->post('descricao') . "' AND status = 1 AND idProdutos <> ".$this->input->post('idProdutos'));
            if (1==1) {
            //if (empty($validaNome)) {
                if (!empty(set_value('codigoInterno'))) {
                    $validaInterno = $this->produtos_model->get('produtos', 'idProdutos', "codigoInterno LIKE '" . $this->input->post('codigoInterno') . "' AND idProdutos <> ".$this->input->post('idProdutos'));
                }
                if (empty($validaInterno)) {
                    if (!empty(set_value('codigoBarras'))) {
                        $validaBarras = $this->produtos_model->get('produtos', 'idProdutos', "codigoBarras LIKE '" . $this->input->post('codigoBarras') . "' AND idProdutos <> ".$this->input->post('idProdutos'));
                    }
                    if (empty($validaBarras)) {
                        $dataProd = array(
                            'descricao' => $this->input->post('descricao'),
                            'sigla' => $this->input->post('sigla'),
                            'observacao' => $this->input->post('observacao'),
                            'unidade' => $this->input->post('unidade'),
                            'estoque' => $this->input->post('estoque'),
                            'estoqueMinimo' => $this->input->post('estoqueMinimo'),
                            'saida' => set_value('saida'),
                            'entrada' => set_value('entrada'),
                            'codigoInterno' => $this->input->post('codigoInterno'),
                            'codigoBarras' => $this->input->post('codigoBarras'),
                            'idFornecedor' => $this->input->post('idFornecedor'),
                            'usuarioEnvio_id' => $this->input->post('usuarioEnvio_id'),
                            'taxaEnvio' => $this->input->post('taxaEnvio'),
                            'categoriaId' => $this->input->post('categoria'),
                            'status' => $this->input->post('status'),
                            'ordem' => $this->input->post('ordem'),
                            'tipo_id' => $this->input->post('tipo_id'),
                            'nomeCatalogo' => $this->input->post('nomeCatalogo'),
                            'descricaoCatalogo' => $this->input->post('descricaoCatalogo'),
                            'pesado' => $this->input->post('pesado'),
                            'link' => $this->input->post('link'),
                            'is_bot' => 0
                        );

                        if (!empty($_FILES['userfile']['name'])) {


                            $arquivo = $this->do_upload('imagem_produto');

                            $file = $arquivo['file_name'];
                            $path = $arquivo['full_path'];
                            $url = base_url() . 'assets/imagem_produto/' . date('d-m-Y') . '/' . $file;
                            $tamanho = $arquivo['file_size'];
                            $tipo = $arquivo['file_ext'];
                            $data = $this->input->post('data');
                            if ($data == null) {
                                $data = date('Y-m-d');
                            } else {
                                $data = explode('/', $data);
                                $data = $data[2] . '-' . $data[1] . '-' . $data[0];
                            }

                            $dataDoc = array(
                                'documento' => $this->input->post('nome'),
                                'descricao' => "Produto ".$this->input->post('idProdutos'),
                                'file' => $file,
                                'path' => $path,
                                'url' => $url,
                                'cadastro' => $data,
                                'tamanho' => $tamanho,
                                'tipo' => $tipo
                            );

                            if ($this->arquivos_model->add('documentos', $dataDoc) == TRUE) {
                                $this->session->set_flashdata('success', 'Arquivo adicionado com sucesso!');
                                $dataProd['imagem'] = $url;
                            } else {
                                $this->data['custom_error'] = '<div class="form_error"><p>Ocorreu um erro.</p></div>';
                            }
                        }

                        if ($this->produtos_model->edit('produtos', $dataProd, 'idProdutos', $this->input->post('idProdutos')) == TRUE) {

                            $permissoes = $this->permissoes_model->get('permissoes', '*', "compra_ativa = 1");

                            foreach ($permissoes as $permissao){
                                $this->usuarioValor_model->deleteWhere('usuario_valor', array('usuario_id' => $permissao->idPermissao, 'produto_id'=> $this->input->post('idProdutos')));
                                $valores = $_POST['valores'];
                                //FOREACH NOS VALORES
                                foreach ($valores[$permissao->idPermissao] as $v){

                                    if($v['valor'] != 0){
                                        $data = array(
                                            'de' => $v['de'],
                                            'ate' => $v['ate'],
                                            'usuario_id' => $permissao->idPermissao,
                                            'produto_id' => $this->input->post('idProdutos'),
                                            'valor' => $v['valor'],
                                        );


                                        $this->usuarioValor_model->add('usuario_valor', $data);
                                    }

                                }


                            }
                            $this->session->set_flashdata('success', 'Produto editado com sucesso!');
                            redirect(base_url() . 'index.php/produtos/editar/' . $this->input->post('idProdutos'));
                        } else {
                            $this->data['custom_error'] = '<div class="form_error"><p>An Error Occured</p></div>';

                        }
                    } else {
                        $this->data['custom_error'] = '<div class="form_error"><p>Já existe um produto com este código de barras cadastrado.</p></div>';
                    }
                } else {
                    $this->data['custom_error'] = '<div class="form_error"><p>Já existe um produto com este código interno cadastrado.</p></div>';
                }
            } else {
                $this->data['custom_error'] = '<div class="form_error"><p>Já existe um produto com esta descrição cadastrada.</p></div>';
            }
        }
        $vendas = $this->vendas_model->getByProduto($this->uri->segment(3));
        $this->data['vendas'] = array();
        foreach ($vendas as $v){
            if(!empty($this->data['vendas'][$v->dataVenda])){
                $this->data['vendas'][$v->dataVenda] += $v->quantidade;
            }else{
                $this->data['vendas'][$v->dataVenda] = $v->quantidade;
            }

        }


        $this->data['result'] = $this->produtos_model->getById($this->uri->segment(3));
        $tipoUnidades = $this->db->get('tipo_unidade')->result();
        foreach ($tipoUnidades as $tipoUnid) {
            $this->data['tipoUnidade'][$tipoUnid->siglaTipoUnidade] = $tipoUnid->nomeTipoUnidade;
        }

        $categorias = $this->db->get('categorias')->result();
        foreach ($categorias as $categoria) {
            $this->data['categorias'][$categoria->idCategorias] = $categoria->categoria;
        }

//        $fornecedores = $this->db->get('usuarios','*','fornecedor = 1');
        $fornecedores = $this->Usuarios_model->getUsuarios('fornecedor = 1');

        foreach ($fornecedores as $fornecedor) {
            $this->data['fornecedores'][$fornecedor->idUsuarios] = "#$fornecedor->idUsuarios - $fornecedor->nome";
        }


        $enviadores = $this->Usuarios_model->getUsuarios('enviador = 1');
        foreach ($enviadores as $enviador) {
            $this->data['enviadores'][$enviador->idUsuarios] = "#$enviador->idUsuarios - $enviador->nome";
        }

        $tipos = $this->db->get('tipo_produto')->result();

        foreach ($tipos as $tipo) {
            $this->data['tipos'][$tipo->id] = $tipo->nome;
        }

        //$permissoes = $this->db->get('permissoes')->result();
        $permissoes = $this->permissoes_model->get('permissoes', '*', "compra_ativa = 1");

        foreach ($permissoes as $permissao) {
            $this->data['permissoes'][$permissao->idPermissao] = $permissao->nome;
        }

        $this->data['usuarios'] = $this->Usuarios_model->get();
        $this->data['usuarioValores'] = array();
        $i = 1;
        foreach ($permissoes as $p) {

            $usuarioValor = @$this->UsuarioValor_model->get('usuario_valor', '*', "usuario_id = ".$p->idPermissao." AND produto_id = " . $this->uri->segment(3));

            if(!empty($usuarioValor)){
                foreach ($usuarioValor as $uv){
                    $this->data['usuarioValores'][$p->idPermissao][$i]["de"] = $uv->de;
                    $this->data['usuarioValores'][$p->idPermissao][$i]["ate"] = $uv->ate;
                    $this->data['usuarioValores'][$p->idPermissao][$i]["valor"] = $uv->valor;
                    $i++;
                }

            }else{
                $this->data['usuarioValores'][$p->idPermissao][1]["de"] = 1;
                $this->data['usuarioValores'][$p->idPermissao][1]["ate"] = 1000;
                $this->data['usuarioValores'][$p->idPermissao][1]["valor"] = 0.00;
            }

        }

        $this->data['view'] = 'produtos/editarProduto';
        $this->load->view('tema/topo', $this->data);

    }


    function visualizar()
    {

        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vProduto')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar produtos.');
            redirect(base_url());
        }

        $this->data['result'] = $this->produtos_model->getById($this->uri->segment(3));

        if ($this->data['result'] == null) {
            $this->session->set_flashdata('error', 'Produto não encontrado.');
            redirect(base_url() . 'index.php/produtos/editar/' . $this->input->post('idProdutos'));
        }
        $this->data['tipoUnidade'] = $this->db->get_where('tipo_unidade', array('siglaTipoUnidade' => $this->data['result']->unidade))->result()[0];

        $this->data['view'] = 'produtos/visualizarProduto';
        $this->load->view('tema/topo', $this->data);

    }

    function duplicar()
    {

        if (!$this->uri->segment(3) || !is_numeric($this->uri->segment(3))) {
            $this->session->set_flashdata('error', 'Item não pode ser encontrado, parâmetro não foi passado corretamente.');
            redirect('mapos');
        }

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'vProduto')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para visualizar produtos.');
            redirect(base_url());
        }

        $this->data['result'] = $this->produtos_model->getById($this->uri->segment(3));


        $data = array(
            'descricao' => $this->data['result']->descricao ." Cópia",
            'sigla' => $this->data['result']->sigla,
            'observacao' => $this->data['result']->observacao,
            'unidade' => $this->data['result']->unidade,

            'estoque' => $this->data['result']->estoque,
            'estoqueMinimo' => $this->data['result']->estoqueMinimo,
            'saida' => $this->data['result']->saida,
            'entrada' => $this->data['result']->entrada,


            'idFornecedor' => $this->data['result']->idFornecedor,
            'usuarioEnvio_id' => $this->data['result']->usuarioEnvio_id,
            'taxaEnvio' => $this->data['result']->taxaEnvio,
            'categoriaId' => $this->data['result']->categoriaId,
            'status' => 0,
            'ordem' =>$this->data['result']->ordem,
            'tipo_id' => $this->data['result']->tipo_id,
            'nomeCatalogo' => $this->data['result']->nomeCatalogo,
            'descricaoCatalogo' => $this->data['result']->descricaoCatalogo,
            'pesado' => $this->data['result']->pesado,

        );


        if ($this->produtos_model->add('produtos', $data) == TRUE) {
            $idProduto = $this->db->insert_id("produtos");
            $permissoes = $this->permissoes_model->get('permissoes', '*', "compra_ativa = 1");

            foreach ($permissoes as $permissao) {

                $valores = $this->produtos_model->getValorProdutoPerfil($this->uri->segment(3), $permissao->idPermissao);
                foreach ($valores as $v){


                        if($v->valor != 0){
                            $data = array(
                                'de' => $v->de,
                                'ate' => $v->ate,
                                'usuario_id' => $permissao->idPermissao,
                                'produto_id' => $idProduto,
                                'valor' => $v->valor,
                            );


                            $this->usuarioValor_model->add('usuario_valor', $data);
                        }
                }

            }
            redirect(base_url() . 'index.php/produtos/editar/'.$idProduto);

        }else{
            echo "erro";
            exit;
        }
    }
    function excluirBot()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'dProduto')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para excluir produtos.');
            redirect(base_url());
        }

        if($_POST['produto_id']){
            $produto_id = $_POST['produto_id'];
            $categoria_id = $_POST['categoria_id'];

            $dataProd = array(
                'is_bot' => 0
            );

            if ($this->produtos_model->edit('produtos', $dataProd, 'idProdutos', $produto_id) == TRUE) {
                redirect(base_url() . 'index.php/produtos/listaProdutosRel/' . $categoria_id);
            }
        }
    }
    function excluir()
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'dProduto')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para excluir produtos.');
            redirect(base_url());
        }


        $id = $this->input->post('id');
        if ($id == null) {

            $this->session->set_flashdata('error', 'Erro ao tentar excluir produto.');
            redirect(base_url() . 'index.php/produtos/gerenciar/');
        }

        $this->db->where('produtos_id', $id);
        $this->db->delete('produtos_os');


        $this->db->where('produtos_id', $id);
        $this->db->delete('itens_de_vendas');

        $this->produtos_model->delete('produtos', 'idProdutos', $id);


        $this->session->set_flashdata('success', 'Produto excluido com sucesso!');
        redirect(base_url() . 'index.php/produtos/gerenciar/');
    }
    public function do_upload($path = null)
    {

        if (!$this->permission->checkPermission($this->session->userdata('permissao'), 'aArquivo')) {
            $this->session->set_flashdata('error', 'Você não tem permissão para adicionar arquivos.');
            redirect(base_url());
        }
        if($path == null){
            $path = 'arquivos';
        }


        $date = date('d-m-Y');

        $config['upload_path'] = './assets/'.$path.'/' . $date;
        $config['allowed_types'] = 'txt|jpg|jpeg|gif|png|pdf|PDF|JPG|JPEG|GIF|PNG';
        $config['max_size'] = 0;
        $config['max_width'] = '10000';
        $config['max_height'] = '10000';
        $config['encrypt_name'] = true;


        if (!is_dir('./assets/'.$path.'/' . $date)) {

            mkdir('./assets/'.$path.'/' . $date, 0777, TRUE);

        }

        $this->load->library('upload', $config);

        if (!$this->upload->do_upload()) {
            $error = array('error' => $this->upload->display_errors());
            echo "<pre>";
            print_r($error);
            echo "</pre>";
            exit;
            $this->session->set_flashdata('error', 'Erro ao fazer upload do arquivo, verifique se a extensão do arquivo é permitida.');
            redirect(base_url() . 'index.php/arquivos/adicionar/');
        } else {
            //$data = array('upload_data' => $this->upload->data());
            return $this->upload->data();
        }
    }
    /*
    function enviarMensagem() {
        const chat_id = document.getElementById('chat_id').value;
        const vendedor = document.getElementById('vendedor_nome').value;
        const mensagem = document.getElementById('mensagem').value;
        const fileInput = document.getElementById('fileInput').files[0];

        if (!mensagem.trim() && !fileInput) {
            alert('Por favor, digite uma mensagem ou selecione um arquivo para enviar.');
            return;
        }

        const formData = new FormData();
        formData.append('chat_id', chat_id);
        formData.append('mensagem', mensagem);
        if (fileInput) {
            formData.append('file', fileInput);
        }
        formData.append('<?php echo $this->security->get_csrf_token_name(); ?>', '<?php echo $this->security->get_csrf_hash(); ?>');

        $.ajax({
            url: '<?php echo site_url('relatorios/enviarMensagemTelegram'); ?>',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    document.getElementById('successVendedorName').textContent = vendedor;
                    new bootstrap.Modal(document.getElementById('successModal')).show();
                    bootstrap.Modal.getInstance(document.getElementById('mensagemModal')).hide();
                } else {
                    alert('Erro ao enviar mensagem: ' + (response.error || 'Erro desconhecido'));
                }
            },
            error: function(xhr, status, error) {
                console.log('Status:', status);
                console.log('Error:', error);
                console.log('Response:', xhr.responseText);
                alert('Erro ao enviar mensagem. Verifique o console para mais detalhes.');
            }
        });
    }*/
}

